/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.EntityRowMapper;
import org.springframework.data.jdbc.core.MapEntityRowMapper;
import org.springframework.data.jdbc.core.SqlGenerator;
import org.springframework.data.jdbc.core.SqlGeneratorSource;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDataAccessStrategy
implements DataAccessStrategy {
    private static final String ENTITY_NEW_AFTER_INSERT = "Entity [%s] still 'new' after insert. Please set either the id property in a BeforeInsert event handler, or ensure the database creates a value and your JDBC driver returns it.";
    @NonNull
    private final SqlGeneratorSource sqlGeneratorSource;
    @NonNull
    private final RelationalMappingContext context;
    @NonNull
    private final RelationalConverter converter;
    @NonNull
    private final NamedParameterJdbcOperations operations;
    @NonNull
    private final DataAccessStrategy accessStrategy;

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, RelationalConverter converter, NamedParameterJdbcOperations operations) {
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.operations = operations;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = this;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Map<String, Object> additionalParameters) {
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(additionalParameters);
        MapSqlParameterSource parameterSource = this.getPropertyMap(instance, persistentEntity);
        Object idValue = this.getIdValueOrNull(instance, persistentEntity);
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idValue != null) {
            Assert.notNull((Object)idProperty, (String)"Since we have a non-null idValue, we must have an idProperty as well.");
            parameters.put(idProperty.getColumnName(), this.converter.writeValue(idValue, (TypeInformation<?>)ClassTypeInformation.from(idProperty.getColumnType())));
        }
        parameters.forEach((arg_0, arg_1) -> ((MapSqlParameterSource)parameterSource).addValue(arg_0, arg_1));
        this.operations.update(this.sql(domainType).getInsert(parameters.keySet()), (SqlParameterSource)parameterSource, (KeyHolder)holder);
        return this.getIdFromHolder((KeyHolder)holder, persistentEntity);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        return this.operations.update(this.sql(domainType).getUpdate(), (SqlParameterSource)this.getPropertyMap(instance, persistentEntity)) != 0;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String deleteByIdSql = this.sql(domainType).getDeleteById();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        this.operations.update(deleteByIdSql, (SqlParameterSource)parameter);
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType());
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + propertyPath));
        String format = this.sql(rootEntity.getType()).createDeleteByPath(propertyPath);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootId", rootId);
        this.operations.update(format, parameters);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.operations.getJdbcOperations().update(this.sql(domainType).createDeleteAllSql(null));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.operations.getJdbcOperations().update(this.sql(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType()).createDeleteAllSql(propertyPath));
    }

    @Override
    public long count(Class<?> domainType) {
        Long result = (Long)this.operations.getJdbcOperations().queryForObject(this.sql(domainType).getCount(), Long.class);
        Assert.notNull((Object)result, (String)"The result of a count query must not be null.");
        return result;
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String findOneSql = this.sql(domainType).getFindOne();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        try {
            return (T)this.operations.queryForObject(findOneSql, (SqlParameterSource)parameter, this.getEntityRowMapper(domainType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.operations.query(this.sql(domainType).getFindAll(), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        Class<?> targetType = ((RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty()).getColumnType();
        MapSqlParameterSource parameter = new MapSqlParameterSource("ids", StreamSupport.stream(ids.spliterator(), false).map(id -> this.converter.writeValue(id, (TypeInformation<?>)ClassTypeInformation.from((Class)targetType))).collect(Collectors.toList()));
        return this.operations.query(findAllInListSql, (SqlParameterSource)parameter, this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllByProperty(Object rootId, RelationalPersistentProperty property) {
        Assert.notNull((Object)rootId, (String)"rootId must not be null.");
        Class actualType = property.getActualType();
        String findAllByProperty = this.sql(actualType).getFindAllByProperty(property.getReverseColumnName(), property.getKeyColumn(), property.isOrdered());
        MapSqlParameterSource parameter = new MapSqlParameterSource(property.getReverseColumnName(), rootId);
        return this.operations.query(findAllByProperty, (SqlParameterSource)parameter, property.isMap() ? this.getMapEntityRowMapper(property) : this.getEntityRowMapper(actualType));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        String existsSql = this.sql(domainType).getExists();
        MapSqlParameterSource parameter = this.createIdParameterSource(id, domainType);
        Boolean result = (Boolean)this.operations.queryForObject(existsSql, (SqlParameterSource)parameter, Boolean.class);
        Assert.notNull((Object)result, (String)"The result of an exists query must not be null");
        return result;
    }

    private <S> MapSqlParameterSource getPropertyMap(S instance, RelationalPersistentEntity<S> persistentEntity) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(instance);
        persistentEntity.doWithProperties(property -> {
            if (!property.isEntity()) {
                Object value = propertyAccessor.getProperty(property);
                Object convertedValue = this.converter.writeValue(value, (TypeInformation<?>)ClassTypeInformation.from(property.getColumnType()));
                parameters.addValue(property.getColumnName(), convertedValue, JdbcUtil.sqlTypeFor(property.getColumnType()));
            }
        });
        return parameters;
    }

    @Nullable
    private <S, ID> ID getIdValueOrNull(S instance, RelationalPersistentEntity<S> persistentEntity) {
        Object idValue = persistentEntity.getIdentifierAccessor(instance).getIdentifier();
        return (ID)(DefaultDataAccessStrategy.isIdPropertyNullOrScalarZero(idValue, persistentEntity) ? null : idValue);
    }

    private static <S, ID> boolean isIdPropertyNullOrScalarZero(@Nullable ID idValue, RelationalPersistentEntity<S> persistentEntity) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        return idValue == null || idProperty == null || idProperty.getType() == Integer.TYPE && idValue.equals(0) || idProperty.getType() == Long.TYPE && idValue.equals(0L);
    }

    private <S> Object getIdFromHolder(KeyHolder holder, RelationalPersistentEntity<S> persistentEntity) {
        try {
            return holder.getKey();
        }
        catch (InvalidDataAccessApiUsageException e) {
            Map keys = holder.getKeys();
            if (keys == null || persistentEntity.getIdProperty() == null) {
                return null;
            }
            return keys.get(persistentEntity.getIdColumn());
        }
    }

    private EntityRowMapper<?> getEntityRowMapper(Class<?> domainType) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(domainType), this.context, this.converter, this.accessStrategy);
    }

    private RowMapper<?> getMapEntityRowMapper(RelationalPersistentProperty property) {
        String keyColumn = property.getKeyColumn();
        Assert.notNull((Object)keyColumn, () -> "KeyColumn must not be null for " + property);
        return new MapEntityRowMapper(this.getEntityRowMapper(property.getActualType()), keyColumn);
    }

    private <T> MapSqlParameterSource createIdParameterSource(Object id, Class<T> domainType) {
        Class<?> columnType = ((RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty()).getColumnType();
        return new MapSqlParameterSource("id", this.converter.writeValue(id, (TypeInformation<?>)ClassTypeInformation.from(columnType)));
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private SqlGenerator sql(Class<?> domainType) {
        return this.sqlGeneratorSource.getSqlGenerator(domainType);
    }

    public DefaultDataAccessStrategy(@NonNull SqlGeneratorSource sqlGeneratorSource, @NonNull RelationalMappingContext context, @NonNull RelationalConverter converter, @NonNull NamedParameterJdbcOperations operations, @NonNull DataAccessStrategy accessStrategy) {
        if (sqlGeneratorSource == null) {
            throw new IllegalArgumentException("sqlGeneratorSource is marked non-null but is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is marked non-null but is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is marked non-null but is null");
        }
        if (operations == null) {
            throw new IllegalArgumentException("operations is marked non-null but is null");
        }
        if (accessStrategy == null) {
            throw new IllegalArgumentException("accessStrategy is marked non-null but is null");
        }
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.context = context;
        this.converter = converter;
        this.operations = operations;
        this.accessStrategy = accessStrategy;
    }
}

