/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import java.util.Collection;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.AbstractPropertiesConfiguredBeanDefinitionParser;
import org.springframework.data.hadoop.config.namespace.HiveRunnerParser;
import org.springframework.data.hadoop.hive.HiveServerFactoryBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class HiveServerParser
extends AbstractPropertiesConfiguredBeanDefinitionParser {
    HiveServerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return HiveServerFactoryBean.class;
    }

    @Override
    protected String defaultId(ParserContext context, Element element) {
        return "hiveServer";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Collection<Object> scripts;
        super.doParse(element, parserContext, builder);
        String props = DomUtils.getTextValue((Element)element);
        if (StringUtils.hasText((String)props)) {
            builder.addPropertyValue("properties", (Object)props);
        }
        if (!CollectionUtils.isEmpty(scripts = HiveRunnerParser.parseScripts(parserContext, element))) {
            builder.addPropertyValue("scripts", scripts);
        }
    }
}

