/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.support.IdleTimeoutTrigger;
import org.springframework.data.hadoop.store.support.LifecycleObjectSupport;
import org.springframework.data.hadoop.store.support.PollingTaskSupport;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public abstract class StoreObjectSupport
extends LifecycleObjectSupport {
    private static final Log log = LogFactory.getLog(StoreObjectSupport.class);
    private final Configuration configuration;
    private final CodecInfo codecInfo;
    private final Path basePath;
    private IdleTimeoutPoller idlePoller;
    private volatile IdleTimeoutTrigger idleTrigger;
    private CloseTimeoutPoller closePoller;
    private volatile IdleTimeoutTrigger closeTrigger;
    private FlushTimeoutPoller flushPoller;
    private volatile IdleTimeoutTrigger flushTrigger;
    private volatile long lastIdle = Long.MIN_VALUE;
    private volatile long idleTimeout;
    private volatile long closeTimeout;
    private volatile long flushTimeout;

    public StoreObjectSupport(Configuration configuration, Path basePath, CodecInfo codec) {
        this.configuration = configuration;
        this.basePath = basePath;
        this.codecInfo = codec;
    }

    @Override
    protected void onInit() throws Exception {
        if (this.idleTimeout > 0L) {
            this.idleTrigger = new IdleTimeoutTrigger(this.idleTimeout);
            this.idlePoller = new IdleTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.idleTrigger);
            this.idlePoller.init();
        }
        if (this.closeTimeout > 0L) {
            this.closeTrigger = new IdleTimeoutTrigger(this.closeTimeout);
            this.closeTrigger.setInitialDelay(this.closeTimeout);
            this.closePoller = new CloseTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.closeTrigger);
            this.closePoller.init();
        }
        if (this.flushTimeout > 0L) {
            this.flushTrigger = new IdleTimeoutTrigger(this.flushTimeout);
            this.flushTrigger.setInitialDelay(this.flushTimeout);
            this.flushPoller = new FlushTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.flushTrigger);
            this.flushPoller.init();
        }
    }

    @Override
    protected void doStart() {
        if (this.idlePoller != null) {
            this.idlePoller.start();
        }
        if (this.closePoller != null) {
            this.closePoller.start();
        }
        if (this.flushPoller != null) {
            this.flushPoller.start();
        }
    }

    @Override
    protected void doStop() {
        if (this.flushPoller != null) {
            this.flushPoller.stop();
        }
        this.flushPoller = null;
        if (this.idlePoller != null) {
            this.idlePoller.stop();
        }
        this.idlePoller = null;
        if (this.closePoller != null) {
            this.closePoller.stop();
        }
        this.closePoller = null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Path getPath() {
        return this.basePath;
    }

    public CodecInfo getCodec() {
        return this.codecInfo;
    }

    public boolean isCompressed() {
        return this.codecInfo != null;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setFlushTimeout(long flushTimeout) {
        this.flushTimeout = flushTimeout;
    }

    public void resetIdleTimeout() {
        this.lastIdle = System.currentTimeMillis();
    }

    protected void handleTimeout() {
    }

    protected void flushTimeout() {
    }

    private class FlushTimeoutPoller
    extends PollingTaskSupport<Void> {
        public FlushTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Void doPoll() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Flush timeout detected, calling flushTimeout()");
                }
                StoreObjectSupport.this.flushTimeout();
            }
            catch (Exception e) {
                log.error((Object)"error flushing", (Throwable)e);
            }
            return null;
        }
    }

    private class CloseTimeoutPoller
    extends PollingTaskSupport<Void> {
        public CloseTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Void doPoll() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Close timeout detected, calling handleTimeout()");
                }
                StoreObjectSupport.this.handleTimeout();
            }
            catch (Exception e) {
                log.error((Object)"error closing", (Throwable)e);
            }
            return null;
        }
    }

    private class IdleTimeoutPoller
    extends PollingTaskSupport<Boolean> {
        public IdleTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Boolean doPoll() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Polling idle timeout with idleTimeout=" + StoreObjectSupport.this.idleTimeout + " lastIdle=" + StoreObjectSupport.this.lastIdle));
            }
            return StoreObjectSupport.this.idleTimeout > 0L && StoreObjectSupport.this.lastIdle > 0L && StoreObjectSupport.this.lastIdle + StoreObjectSupport.this.idleTimeout < System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onPollResult(Boolean result) {
            if (result.booleanValue()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Idle timeout detected, calling handleTimeout()");
                    }
                    StoreObjectSupport.this.handleTimeout();
                }
                catch (Exception e) {
                    log.error((Object)"error closing", (Throwable)e);
                }
                finally {
                    StoreObjectSupport.this.lastIdle = Long.MIN_VALUE;
                }
            }
        }
    }
}

