/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.split;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.split.AbstractSplitter;
import org.springframework.data.hadoop.store.split.Split;

public class SlopBlockSplitter
extends AbstractSplitter {
    protected static final double DEFAULT_SPLIT_SLOP = 1.1;
    private long minSplitSize = 1L;
    private long maxSplitSize = Long.MAX_VALUE;
    private double slop = 1.1;

    public SlopBlockSplitter() {
    }

    public SlopBlockSplitter(Configuration configuration) {
        super(configuration);
    }

    public SlopBlockSplitter(Configuration configuration, long minSplitSize, long maxSplitSize) {
        super(configuration);
        this.setMinSplitSize(minSplitSize);
        this.setMaxSplitSize(maxSplitSize);
    }

    public SlopBlockSplitter(Configuration configuration, long minSplitSize, long maxSplitSize, double slop) {
        super(configuration);
        this.setMinSplitSize(minSplitSize);
        this.setMaxSplitSize(maxSplitSize);
        this.setSlop(slop);
    }

    @Override
    public List<Split> getSplits(Path path) throws IOException {
        ArrayList<Split> splits = new ArrayList<Split>();
        FileSystem fs = path.getFileSystem(this.getConfiguration());
        FileStatus status = fs.getFileStatus(path);
        long length = status.getLen();
        BlockLocation[] blocks = fs.getFileBlockLocations(status, 0L, length);
        long blockSize = status.getBlockSize();
        long splitSize = this.computeSplitSize(blockSize, this.getMinSplitSize(), this.getMaxSplitSize());
        long remaining = length;
        while ((double)remaining / (double)splitSize > this.slop) {
            int i = this.getBlockIndex(blocks, length - remaining);
            splits.add(this.buildSplit(length - remaining, splitSize, blocks[i].getHosts()));
            remaining -= splitSize;
        }
        if (remaining != 0L) {
            int blkIndex = this.getBlockIndex(blocks, length - remaining);
            splits.add(this.buildSplit(length - remaining, remaining, blocks[blkIndex].getHosts()));
        }
        return splits;
    }

    public long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    public void setMaxSplitSize(long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public void setSlop(double slop) {
        this.slop = slop;
    }
}

