/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.support.OutputStoreObjectSupport;
import org.springframework.data.hadoop.store.support.SequenceFileWriterHolder;
import org.springframework.util.ClassUtils;

public abstract class AbstractSequenceFileWriter
extends OutputStoreObjectSupport {
    public AbstractSequenceFileWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    protected SequenceFileWriterHolder<SequenceFile.Writer> getOutput() throws IOException {
        SequenceFileWriterHolder<SequenceFile.Writer> holder;
        FileSystem fs = FileSystem.get((Configuration)this.getConfiguration());
        CodecInfo codecInfo = this.getCodec();
        Path p = this.getResolvedPath();
        if (codecInfo == null) {
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.getConfiguration(), (Path)this.getResolvedPath(), Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)null);
            holder = new SequenceFileWriterHolder<SequenceFile.Writer>(writer, p);
        } else {
            Class clazz = ClassUtils.resolveClassName((String)codecInfo.getCodecClass(), (ClassLoader)this.getClass().getClassLoader());
            CompressionCodec compressionCodec = (CompressionCodec)ReflectionUtils.newInstance((Class)clazz, (Configuration)this.getConfiguration());
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.getConfiguration(), (Path)this.getResolvedPath(), Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.RECORD, (CompressionCodec)compressionCodec);
            holder = new SequenceFileWriterHolder<SequenceFile.Writer>(writer, p);
        }
        return holder;
    }

    protected long getPosition(SequenceFile.Writer writer) throws IOException {
        if (writer != null) {
            return writer.getLength();
        }
        return -1L;
    }
}

