/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.springframework.data.hadoop.store.DataStoreReader;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.input.AbstractDataStreamReader;
import org.springframework.data.hadoop.store.split.Split;

public class TextFileReader
extends AbstractDataStreamReader
implements DataStoreReader<String> {
    private AbstractDataStreamReader.ReaderHelper<LineReader, byte[]> readerHelper;
    private final byte[] delimiter;

    public TextFileReader(Configuration configuration, Path basePath, CodecInfo codec) {
        this(configuration, basePath, codec, null);
    }

    public TextFileReader(Configuration configuration, Path basePath, CodecInfo codec, Split split) {
        this(configuration, basePath, codec, split, null);
    }

    public TextFileReader(Configuration configuration, Path basePath, CodecInfo codec, Split split, byte[] delimiter) {
        super(configuration, basePath, codec, split);
        this.delimiter = delimiter;
    }

    @Override
    public void close() throws IOException {
        if (this.readerHelper != null) {
            if (this.readerHelper.getReader() != null) {
                this.readerHelper.getReader().close();
            }
            if (this.readerHelper.getHolder() != null) {
                this.readerHelper.getHolder().close();
            }
            this.readerHelper = null;
        }
    }

    @Override
    public String read() throws IOException {
        byte[] value;
        if (this.readerHelper == null) {
            this.readerHelper = new AbstractDataStreamReader.ReaderHelper<LineReader, byte[]>(this.getInput(), this.getInputContext(), this.getSplit(), this.getCodec()){

                @Override
                protected LineReader createReader(InputStream inputStream) throws IOException {
                    LineReader lineReader = new LineReader(inputStream, TextFileReader.this.delimiter);
                    if (this.getContext().getStart() > 0L) {
                        this.processReadCount(lineReader.readLine(new Text()));
                    }
                    return lineReader;
                }

                @Override
                protected byte[] doRead(LineReader delegate) throws IOException {
                    Text text = new Text();
                    if (!TextFileReader.this.getInputContext().isEndReached()) {
                        this.processReadCount(delegate.readLine(text));
                    }
                    return text.getBytes();
                }
            };
            this.readerHelper.init();
        }
        return (value = this.readerHelper.read()) != null && value.length > 0 ? new String(value) : null;
    }
}

