/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.config.annotation.configurers;

import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.data.hadoop.store.config.annotation.SpringDataStoreWriterConfigs;
import org.springframework.data.hadoop.store.config.annotation.builders.DataStoreTextWriterBuilder;
import org.springframework.data.hadoop.store.config.annotation.builders.DataStoreTextWriterConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.PartitionStrategyConfigurer;
import org.springframework.data.hadoop.store.partition.DefaultPartitionStrategy;
import org.springframework.data.hadoop.store.partition.PartitionStrategy;

public class DefaultPartitionStrategyConfigurer
extends AnnotationConfigurerAdapter<SpringDataStoreWriterConfigs, DataStoreTextWriterConfigurer, DataStoreTextWriterBuilder>
implements PartitionStrategyConfigurer {
    private PartitionStrategy<?, ?> partitionStrategy;

    public void configure(DataStoreTextWriterBuilder builder) throws Exception {
        if (this.partitionStrategy != null) {
            builder.setPartitionStrategy(this.partitionStrategy);
        }
    }

    @Override
    public PartitionStrategyConfigurer custom(PartitionStrategy<?, ?> partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
        return this;
    }

    @Override
    public PartitionStrategyConfigurer map(String expression) {
        this.partitionStrategy = new DefaultPartitionStrategy(expression);
        return this;
    }
}

