/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableClientCacheConfigurer;
import org.springframework.data.gemfire.config.support.ClientRegionPoolBeanFactoryPostProcessor;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.util.StringUtils;

@Configuration
public class ClientCacheConfiguration
extends AbstractCacheConfiguration {
    private static final AtomicBoolean INFRASTRUCTURE_COMPONENTS_REGISTERED = new AtomicBoolean(false);
    protected static final boolean DEFAULT_READY_FOR_EVENTS = false;
    protected static final String DEFAULT_NAME = "SpringBasedCacheClientApplication";
    private boolean readyForEvents = false;
    private Boolean keepAlive;
    private Boolean multiUserAuthentication;
    private Boolean prSingleHopEnabled;
    private Boolean subscriptionEnabled;
    private Boolean threadLocalConnections;
    private Integer durableClientTimeout;
    private Integer freeConnectionTimeout;
    private Integer loadConditioningInterval;
    private Integer maxConnections;
    private Integer minConnections;
    private Integer readTimeout;
    private Integer retryAttempts;
    private Integer socketBufferSize;
    private Integer statisticsInterval;
    private Integer subscriptionAckInterval;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private Iterable<ConnectionEndpoint> locators;
    private Iterable<ConnectionEndpoint> servers;
    @Autowired(required=false)
    private List<ClientCacheConfigurer> clientCacheConfigurers = Collections.emptyList();
    private Long idleTimeout;
    private Long pingInterval;
    private String durableClientId;
    private String serverGroup;

    @Bean
    public ClientCacheFactoryBean gemfireCache() {
        ClientCacheFactoryBean gemfireCache = (ClientCacheFactoryBean)this.constructCacheFactoryBean();
        gemfireCache.setClientCacheConfigurers(this.resolveClientCacheConfigurers());
        gemfireCache.setDurableClientId(this.getDurableClientId());
        gemfireCache.setDurableClientTimeout(this.getDurableClientTimeout());
        gemfireCache.setFreeConnectionTimeout(this.getFreeConnectionTimeout());
        gemfireCache.setIdleTimeout(this.getIdleTimeout());
        gemfireCache.setKeepAlive(this.getKeepAlive());
        gemfireCache.setLocators(this.getPoolLocators());
        gemfireCache.setLoadConditioningInterval(this.getLoadConditioningInterval());
        gemfireCache.setMaxConnections(this.getMaxConnections());
        gemfireCache.setMinConnections(this.getMinConnections());
        gemfireCache.setMultiUserAuthentication(this.getMultiUserAuthentication());
        gemfireCache.setPingInterval(this.getPingInterval());
        gemfireCache.setPrSingleHopEnabled(this.getPrSingleHopEnabled());
        gemfireCache.setReadTimeout(this.getReadTimeout());
        gemfireCache.setReadyForEvents(this.getReadyForEvents());
        gemfireCache.setRetryAttempts(this.getRetryAttempts());
        gemfireCache.setServerGroup(this.getServerGroup());
        gemfireCache.setServers(this.getPoolServers());
        gemfireCache.setSocketBufferSize(this.getSocketBufferSize());
        gemfireCache.setStatisticsInterval(this.getStatisticsInterval());
        gemfireCache.setSubscriptionAckInterval(this.getSubscriptionAckInterval());
        gemfireCache.setSubscriptionEnabled(this.getSubscriptionEnabled());
        gemfireCache.setSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout());
        gemfireCache.setSubscriptionRedundancy(this.getSubscriptionRedundancy());
        gemfireCache.setThreadLocalConnections(this.getThreadLocalConnections());
        return gemfireCache;
    }

    private List<ClientCacheConfigurer> resolveClientCacheConfigurers() {
        return Optional.ofNullable(this.clientCacheConfigurers).filter(clientCacheConfigurers -> !clientCacheConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableClientCacheConfigurer.create(this.getBeanFactory())));
    }

    @Override
    protected <T extends CacheFactoryBean> T newCacheFactoryBean() {
        return (T)new ClientCacheFactoryBean();
    }

    @Override
    protected void configureInfrastructure(AnnotationMetadata importMetadata) {
        super.configureInfrastructure(importMetadata);
        this.registerInfrastructureComponents(importMetadata);
    }

    private void registerInfrastructureComponents(AnnotationMetadata importMetadata) {
        if (INFRASTRUCTURE_COMPONENTS_REGISTERED.compareAndSet(false, true)) {
            this.register(BeanDefinitionBuilder.rootBeanDefinition(ClientRegionPoolBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition());
        }
    }

    @Override
    protected void configureCache(AnnotationMetadata importMetadata) {
        super.configureCache(importMetadata);
        if (this.isClientCacheApplication(importMetadata)) {
            AnnotationAttributes clientCacheApplicationAttributes = this.getAnnotationAttributes(importMetadata);
            this.setDurableClientId(this.resolveProperty(this.cacheClientProperty("durable-client-id"), (String)clientCacheApplicationAttributes.get((Object)"durableClientId")));
            this.setDurableClientTimeout(this.resolveProperty(this.cacheClientProperty("durable-client-timeout"), (Integer)clientCacheApplicationAttributes.get((Object)"durableClientTimeout")));
            this.setFreeConnectionTimeout(this.resolveProperty(this.namedPoolProperty("default", "free-connection-timeout"), this.resolveProperty(this.poolProperty("free-connection-timeout"), (Integer)clientCacheApplicationAttributes.get((Object)"freeConnectionTimeout"))));
            this.setIdleTimeout(this.resolveProperty(this.namedPoolProperty("default", "idle-timeout"), this.resolveProperty(this.poolProperty("idle-timeout"), (Long)clientCacheApplicationAttributes.get((Object)"idleTimeout"))));
            this.setKeepAlive(this.resolveProperty(this.cacheClientProperty("keep-alive"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"keepAlive"))));
            this.setLoadConditioningInterval(this.resolveProperty(this.namedPoolProperty("default", "load-conditioning-interval"), this.resolveProperty(this.poolProperty("load-conditioning-interval"), (Integer)clientCacheApplicationAttributes.get((Object)"loadConditioningInterval"))));
            this.setMaxConnections(this.resolveProperty(this.namedPoolProperty("default", "max-connections"), this.resolveProperty(this.poolProperty("max-connections"), (Integer)clientCacheApplicationAttributes.get((Object)"maxConnections"))));
            this.setMinConnections(this.resolveProperty(this.namedPoolProperty("default", "min-connections"), this.resolveProperty(this.poolProperty("min-connections"), (Integer)clientCacheApplicationAttributes.get((Object)"minConnections"))));
            this.setMultiUserAuthentication(this.resolveProperty(this.namedPoolProperty("default", "multi-user-authentication"), this.resolveProperty(this.poolProperty("multi-user-authentication"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"multiUserAuthentication")))));
            this.setPingInterval(this.resolveProperty(this.namedPoolProperty("default", "ping-interval"), this.resolveProperty(this.poolProperty("ping-interval"), (Long)clientCacheApplicationAttributes.get((Object)"pingInterval"))));
            this.setPrSingleHopEnabled(this.resolveProperty(this.namedPoolProperty("default", "pr-single-hop-enabled"), this.resolveProperty(this.poolProperty("pr-single-hop-enabled"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"prSingleHopEnabled")))));
            this.setReadTimeout(this.resolveProperty(this.namedPoolProperty("default", "read-timeout"), this.resolveProperty(this.poolProperty("read-timeout"), (Integer)clientCacheApplicationAttributes.get((Object)"readTimeout"))));
            this.setReadyForEvents(this.resolveProperty(this.namedPoolProperty("default", "ready-for-events"), this.resolveProperty(this.poolProperty("ready-for-events"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"readyForEvents")))));
            this.setRetryAttempts(this.resolveProperty(this.namedPoolProperty("default", "retry-attempts"), this.resolveProperty(this.poolProperty("retry-attempts"), (Integer)clientCacheApplicationAttributes.get((Object)"retryAttempts"))));
            this.setServerGroup(this.resolveProperty(this.namedPoolProperty("default", "server-group"), this.resolveProperty(this.poolProperty("server-group"), (String)clientCacheApplicationAttributes.get((Object)"serverGroup"))));
            this.setSocketBufferSize(this.resolveProperty(this.namedPoolProperty("default", "socket-buffer-size"), this.resolveProperty(this.poolProperty("socket-buffer-size"), (Integer)clientCacheApplicationAttributes.get((Object)"socketBufferSize"))));
            this.setStatisticsInterval(this.resolveProperty(this.namedPoolProperty("default", "statistic-interval"), this.resolveProperty(this.poolProperty("statistic-interval"), (Integer)clientCacheApplicationAttributes.get((Object)"statisticInterval"))));
            this.setSubscriptionAckInterval(this.resolveProperty(this.namedPoolProperty("default", "subscription-ack-interval"), this.resolveProperty(this.poolProperty("subscription-ack-interval"), (Integer)clientCacheApplicationAttributes.get((Object)"subscriptionAckInterval"))));
            this.setSubscriptionEnabled(this.resolveProperty(this.namedPoolProperty("default", "subscription-enabled"), this.resolveProperty(this.poolProperty("subscription-enabled"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"subscriptionEnabled")))));
            this.setSubscriptionMessageTrackingTimeout(this.resolveProperty(this.namedPoolProperty("default", "subscription-message-tracking-timeout"), this.resolveProperty(this.poolProperty("subscription-message-tracking-timeout"), (Integer)clientCacheApplicationAttributes.get((Object)"subscriptionMessageTrackingTimeout"))));
            this.setSubscriptionRedundancy(this.resolveProperty(this.namedPoolProperty("default", "subscription-redundancy"), this.resolveProperty(this.poolProperty("subscription-redundancy"), (Integer)clientCacheApplicationAttributes.get((Object)"subscriptionRedundancy"))));
            this.setThreadLocalConnections(this.resolveProperty(this.namedPoolProperty("default", "thread-local-connections"), this.resolveProperty(this.poolProperty("thread-local-connections"), Boolean.TRUE.equals(clientCacheApplicationAttributes.get((Object)"threadLocalConnections")))));
            this.configureLocatorsAndServers((Map<String, Object>)clientCacheApplicationAttributes);
        }
    }

    private void configureLocatorsAndServers(Map<String, Object> clientCacheApplicationAttributes) {
        ConnectionEndpointList poolServers;
        ConnectionEndpointList poolLocators;
        String locatorsFromProperty = this.resolveProperty(this.namedPoolProperty("default", "locators"), this.resolveProperty(this.poolProperty("locators"), (String)null));
        if (StringUtils.hasText((String)locatorsFromProperty)) {
            String[] locatorHostsPorts = locatorsFromProperty.split(",");
            poolLocators = ConnectionEndpointList.parse(10334, locatorHostsPorts);
        } else {
            AnnotationAttributes[] locators;
            poolLocators = new ConnectionEndpointList();
            for (AnnotationAttributes locator : locators = (AnnotationAttributes[])clientCacheApplicationAttributes.get("locators")) {
                poolLocators.add(this.newConnectionEndpoint((String)locator.get((Object)"host"), (Integer)locator.get((Object)"port")));
            }
        }
        this.setPoolLocators(poolLocators);
        String serversFromProperty = this.resolveProperty(this.namedPoolProperty("default", "servers"), this.resolveProperty(this.poolProperty("servers"), (String)null));
        if (StringUtils.hasText((String)serversFromProperty)) {
            String[] serverHostsPorts = serversFromProperty.split(",");
            poolServers = ConnectionEndpointList.parse(40404, serverHostsPorts);
        } else {
            AnnotationAttributes[] servers;
            poolServers = new ConnectionEndpointList();
            for (AnnotationAttributes server : servers = (AnnotationAttributes[])clientCacheApplicationAttributes.get("servers")) {
                poolServers.add(this.newConnectionEndpoint((String)server.get((Object)"host"), (Integer)server.get((Object)"port")));
            }
        }
        this.setPoolServers(poolServers);
    }

    protected ConnectionEndpoint newConnectionEndpoint(String host, Integer port) {
        return new ConnectionEndpoint(host, port);
    }

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return ClientCacheApplication.class;
    }

    void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    protected String getDurableClientId() {
        return this.durableClientId;
    }

    void setDurableClientTimeout(Integer durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    protected Integer getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    void setFreeConnectionTimeout(Integer freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    protected Integer getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected Long getIdleTimeout() {
        return this.idleTimeout;
    }

    void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected Boolean getKeepAlive() {
        return this.keepAlive;
    }

    void setLoadConditioningInterval(Integer loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    protected Integer getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected Integer getMaxConnections() {
        return this.maxConnections;
    }

    void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    protected Integer getMinConnections() {
        return this.minConnections;
    }

    void setMultiUserAuthentication(Boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    protected Boolean getMultiUserAuthentication() {
        return this.multiUserAuthentication;
    }

    void setPingInterval(Long pingInterval) {
        this.pingInterval = pingInterval;
    }

    protected Long getPingInterval() {
        return this.pingInterval;
    }

    void setPoolLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators = locators;
    }

    protected Iterable<ConnectionEndpoint> getPoolLocators() {
        return this.locators;
    }

    void setPoolServers(Iterable<ConnectionEndpoint> servers) {
        this.servers = servers;
    }

    protected Iterable<ConnectionEndpoint> getPoolServers() {
        return this.servers;
    }

    void setPrSingleHopEnabled(Boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    protected Boolean getPrSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected Integer getReadTimeout() {
        return this.readTimeout;
    }

    void setReadyForEvents(boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    protected boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    protected Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    protected String getServerGroup() {
        return this.serverGroup;
    }

    void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    protected Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    void setStatisticsInterval(Integer statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    protected Integer getStatisticsInterval() {
        return this.statisticsInterval;
    }

    void setSubscriptionAckInterval(Integer subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    protected Integer getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    protected Boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    void setSubscriptionMessageTrackingTimeout(Integer subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    protected Integer getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    void setSubscriptionRedundancy(Integer subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    protected Integer getSubscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    void setThreadLocalConnections(Boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    protected Boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

