/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;
import org.springframework.data.gemfire.support.WiringDeclarableSupport;
import org.springframework.util.Assert;

public abstract class LazyWiringDeclarableSupport
extends WiringDeclarableSupport
implements ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private final AtomicReference<Properties> parametersReference = new AtomicReference();
    volatile boolean initialized = false;

    public LazyWiringDeclarableSupport() {
        SpringContextBootstrappingInitializer.register(this);
    }

    protected void assertInitialized() {
        Assert.state((boolean)this.isInitialized(), (String)String.format("This Declarable object [%s] has not been properly configured and initialized", this.getClass().getName()));
    }

    protected void assertUninitialized() {
        Assert.state((boolean)this.isNotInitialized(), (String)String.format("This Declarable object [%s] has already been configured and initialized", this.getClass().getName()));
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isNotInitialized() {
        return !this.isInitialized();
    }

    @Override
    public final void init(Properties parameters) {
        this.setParameters(parameters);
        try {
            this.doInit(this.locateBeanFactory(), this.nullSafeGetParameters());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    synchronized void doInit(BeanFactory beanFactory, Properties parameters) {
        this.initialized = this.isInitialized() || this.configureThis(beanFactory, parameters.getProperty("bean-name"));
        this.doPostInit(parameters);
    }

    protected void doPostInit(Properties parameters) {
    }

    protected Properties nullSafeGetParameters() {
        Properties parameters = this.parametersReference.get();
        return parameters != null ? parameters : new Properties();
    }

    protected void setParameters(Properties parameters) {
        this.parametersReference.set(parameters);
    }

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)String.format("The Spring ApplicationContext [%s] must be an instance of ConfigurableApplicationContext", applicationContext));
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        this.doInit((BeanFactory)beanFactory, this.nullSafeGetParameters());
    }

    public void destroy() throws Exception {
        SpringContextBootstrappingInitializer.unregister(this);
        this.setParameters(null);
        this.initialized = false;
    }
}

