/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.snapshot;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotFilter;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.data.gemfire.snapshot.ExportSnapshotException;
import org.springframework.data.gemfire.snapshot.ImportSnapshotException;
import org.springframework.data.gemfire.snapshot.event.ExportSnapshotApplicationEvent;
import org.springframework.data.gemfire.snapshot.event.SnapshotApplicationEvent;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SnapshotServiceFactoryBean<K, V>
extends AbstractFactoryBeanSupport<SnapshotServiceAdapter<K, V>>
implements InitializingBean,
DisposableBean,
ApplicationListener<SnapshotApplicationEvent<K, V>> {
    protected static final SnapshotMetadata[] EMPTY_ARRAY = new SnapshotMetadata[0];
    private Boolean suppressImportOnInit;
    private Cache cache;
    private Region<K, V> region;
    private SnapshotMetadata<K, V>[] exports;
    private SnapshotMetadata<K, V>[] imports;
    private SnapshotServiceAdapter<K, V> snapshotServiceAdapter;

    static <K, V> SnapshotMetadata<K, V>[] nullSafeArray(SnapshotMetadata<K, V>[] configurations) {
        return configurations != null ? configurations : EMPTY_ARRAY;
    }

    static boolean nullSafeIsDirectory(File file) {
        return file != null && file.isDirectory();
    }

    static boolean nullSafeIsFile(File file) {
        return file != null && file.isFile();
    }

    public void afterPropertiesSet() throws Exception {
        this.snapshotServiceAdapter = this.create();
        if (!this.getSuppressImportOnInit()) {
            this.snapshotServiceAdapter.doImport(this.getImports());
        }
    }

    protected SnapshotServiceAdapter create() {
        return Optional.ofNullable(this.getRegion()).map(region -> this.wrap(region.getSnapshotService())).orElseGet(() -> this.wrap(this.getCache().getSnapshotService()));
    }

    protected SnapshotServiceAdapter<Object, Object> wrap(CacheSnapshotService cacheSnapshotService) {
        return new CacheSnapshotServiceAdapter(cacheSnapshotService);
    }

    protected SnapshotServiceAdapter<K, V> wrap(RegionSnapshotService<K, V> regionSnapshotService) {
        return new RegionSnapshotServiceAdapter<K, V>(regionSnapshotService);
    }

    public void setCache(Cache cache) {
        this.cache = Optional.ofNullable(cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Cache must not be null", new Object[0]));
    }

    protected Cache getCache() {
        return Optional.ofNullable(this.cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("The cache was not properly initialized", new Object[0]));
    }

    public void setExports(SnapshotMetadata<K, V>[] exports) {
        this.exports = exports;
    }

    protected SnapshotMetadata<K, V>[] getExports() {
        return SnapshotServiceFactoryBean.nullSafeArray(this.exports);
    }

    public void setImports(SnapshotMetadata<K, V>[] imports) {
        this.imports = imports;
    }

    protected SnapshotMetadata<K, V>[] getImports() {
        return SnapshotServiceFactoryBean.nullSafeArray(this.imports);
    }

    public void setRegion(Region<K, V> region) {
        this.region = region;
    }

    protected Region<K, V> getRegion() {
        return this.region;
    }

    public void setSuppressImportOnInit(Boolean suppressImportOnInit) {
        this.suppressImportOnInit = suppressImportOnInit;
    }

    protected boolean getSuppressImportOnInit() {
        return Boolean.TRUE.equals(this.suppressImportOnInit);
    }

    public SnapshotServiceAdapter<K, V> getObject() throws Exception {
        return this.snapshotServiceAdapter;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.snapshotServiceAdapter).map(Object::getClass).orElse(SnapshotServiceAdapter.class);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.getObject().doExport(this.getExports());
    }

    public void onApplicationEvent(SnapshotApplicationEvent<K, V> event) {
        try {
            if (this.isMatch(event)) {
                if (event instanceof ExportSnapshotApplicationEvent) {
                    this.getObject().doExport(this.resolveSnapshotMetadata(event));
                } else {
                    this.getObject().doImport(this.resolveSnapshotMetadata(event));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isMatch(SnapshotApplicationEvent event) {
        return event.isCacheSnapshotEvent() || event.matches(this.getRegion());
    }

    protected SnapshotMetadata<K, V>[] resolveSnapshotMetadata(SnapshotApplicationEvent<K, V> event) {
        Object[] eventSnapshotMetadata = event.getSnapshotMetadata();
        return !ObjectUtils.isEmpty((Object[])eventSnapshotMetadata) ? eventSnapshotMetadata : (event instanceof ExportSnapshotApplicationEvent ? this.getExports() : this.getImports());
    }

    protected static final class ArchiveFileFilter
    implements FileFilter {
        protected static final ArchiveFileFilter INSTANCE = new ArchiveFileFilter();
        protected static final List<String> ACCEPTED_FILE_EXTENSIONS = Arrays.asList("jar", "zip");
        protected static final String FILE_EXTENSION_DOT_SEPARATOR = ".";

        protected ArchiveFileFilter() {
        }

        protected boolean isJarFile(File file) {
            return "jar".equalsIgnoreCase(this.getFileExtension(file));
        }

        protected String getFileExtension(File file) {
            String fileExtension = "";
            if (SnapshotServiceFactoryBean.nullSafeIsFile(file)) {
                String pathname = file.getAbsolutePath();
                int fileExtensionIndex = pathname.lastIndexOf(FILE_EXTENSION_DOT_SEPARATOR);
                fileExtension = fileExtensionIndex > -1 ? pathname.substring(fileExtensionIndex + 1) : "";
            }
            return fileExtension.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            return ACCEPTED_FILE_EXTENSIONS.contains(this.getFileExtension(pathname));
        }
    }

    public static class SnapshotMetadata<K, V> {
        protected static final boolean DEFAULT_INVOKE_CALLBACKS = false;
        protected static final boolean DEFAULT_PARALLEL = false;
        protected static final SnapshotOptions.SnapshotFormat DEFAULT_SNAPSHOT_FORMAT = SnapshotOptions.SnapshotFormat.GEMFIRE;
        private boolean invokeCallbacks = false;
        private boolean parallel = false;
        private final File location;
        private final SnapshotFilter<K, V> filter;
        private final SnapshotOptions.SnapshotFormat format;

        public SnapshotMetadata(File location) {
            this(location, DEFAULT_SNAPSHOT_FORMAT, null);
        }

        public SnapshotMetadata(File location, SnapshotOptions.SnapshotFormat format) {
            this(location, format, null);
        }

        public SnapshotMetadata(File location, SnapshotOptions.SnapshotFormat format, SnapshotFilter<K, V> filter) {
            Assert.notNull((Object)location, (String)"Location is required");
            this.location = location;
            this.format = format;
            this.filter = filter;
        }

        public boolean isDirectory() {
            return SnapshotServiceFactoryBean.nullSafeIsDirectory(this.getLocation());
        }

        public boolean isFile() {
            return SnapshotServiceFactoryBean.nullSafeIsFile(this.getLocation());
        }

        public File getLocation() {
            return this.location;
        }

        public SnapshotOptions.SnapshotFormat getFormat() {
            return Optional.ofNullable(this.format).orElse(DEFAULT_SNAPSHOT_FORMAT);
        }

        public boolean isFilterPresent() {
            return this.getFilter() != null;
        }

        public SnapshotFilter<K, V> getFilter() {
            return this.filter;
        }

        public void setInvokeCallbacks(boolean invokeCallbacks) {
            this.invokeCallbacks = invokeCallbacks;
        }

        public boolean isInvokeCallbacks() {
            return this.invokeCallbacks;
        }

        public void setParallel(boolean parallel) {
            this.parallel = parallel;
        }

        public boolean isParallel() {
            return this.parallel;
        }

        public String toString() {
            return String.format("{ @type = %1$s, location = %2$s, format = %3$s, filter = %4$s, invokeCallbacks = %5$s, parallel = %6$s }", this.getClass().getName(), this.getLocation().getAbsolutePath(), this.getFormat(), this.getFilter(), this.isInvokeCallbacks(), this.isParallel());
        }
    }

    protected static class RegionSnapshotServiceAdapter<K, V>
    extends SnapshotServiceAdapterSupport<K, V> {
        private final RegionSnapshotService<K, V> snapshotService;

        public RegionSnapshotServiceAdapter(RegionSnapshotService<K, V> snapshotService) {
            Assert.notNull(snapshotService, (String)"The backing RegionSnapshotService must not be null");
            this.snapshotService = snapshotService;
        }

        protected RegionSnapshotService<K, V> getSnapshotService() {
            return this.snapshotService;
        }

        @Override
        public SnapshotOptions<K, V> createOptions() {
            return this.getSnapshotService().createOptions();
        }

        @Override
        protected File[] handleLocation(SnapshotMetadata<K, V> configuration) {
            return new File[]{configuration.getLocation()};
        }

        @Override
        public void load(File snapshot, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().load(snapshot, format);
            }
            catch (Throwable cause) {
                throw new ImportSnapshotException(String.format("Failed to load snapshot from file [%1$s] in format [%2$s]", snapshot, format), cause);
            }
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options, File ... snapshots) {
            try {
                for (File snapshot : snapshots) {
                    this.getSnapshotService().load(snapshot, format, options);
                }
            }
            catch (Throwable cause) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots [%1$s] in format [%2$s] using options [%3$s]", Arrays.toString(snapshots), format, options), cause);
            }
        }

        @Override
        public void save(File snapshot, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().save(snapshot, format);
            }
            catch (Throwable cause) {
                throw new ExportSnapshotException(String.format("Failed to save snapshot to file [%1$s] in format [%2$s]", snapshot, format), cause);
            }
        }

        @Override
        public void save(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            try {
                this.getSnapshotService().save(snapshot, format, options);
            }
            catch (Throwable cause) {
                throw new ExportSnapshotException(String.format("Failed to save snapshot to file [%1$s] in format [%2$s] using options [%3$s]", snapshot, format, options), cause);
            }
        }
    }

    protected static class CacheSnapshotServiceAdapter
    extends SnapshotServiceAdapterSupport<Object, Object> {
        private final CacheSnapshotService snapshotService;

        public CacheSnapshotServiceAdapter(CacheSnapshotService snapshotService) {
            Assert.notNull((Object)snapshotService, (String)"The backing CacheSnapshotService must not be null");
            this.snapshotService = snapshotService;
        }

        protected CacheSnapshotService getSnapshotService() {
            return this.snapshotService;
        }

        @Override
        public SnapshotOptions<Object, Object> createOptions() {
            return this.getSnapshotService().createOptions();
        }

        @Override
        protected File[] handleLocation(SnapshotMetadata<Object, Object> configuration) {
            return configuration.isFile() ? this.handleFileLocation(configuration.getLocation()) : this.handleDirectoryLocation(configuration.getLocation());
        }

        @Override
        public void load(File directory, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().load(directory, format);
            }
            catch (Throwable cause) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots from directory [%1$s] in format [%2$s]", directory, format), cause);
            }
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options, File ... snapshots) {
            try {
                this.getSnapshotService().load(snapshots, format, options);
            }
            catch (Throwable cause) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots [%1$s] in format [%2$s] using options [%3$s]", Arrays.toString(snapshots), format, options), cause);
            }
        }

        @Override
        public void save(File directory, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().save(directory, format);
            }
            catch (Throwable cause) {
                throw new ExportSnapshotException(String.format("Failed to save snapshots to directory [%1$s] in format [%2$s]", directory, format), cause);
            }
        }

        @Override
        public void save(File directory, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) {
            try {
                this.getSnapshotService().save(directory, format, options);
            }
            catch (Throwable cause) {
                throw new ExportSnapshotException(String.format("Failed to save snapshots to directory [%1$s] in format [%2$s] using options [%3$s]", directory, format, options), cause);
            }
        }
    }

    protected static abstract class SnapshotServiceAdapterSupport<K, V>
    implements SnapshotServiceAdapter<K, V> {
        protected static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
        protected final Log log = this.createLog();

        protected SnapshotServiceAdapterSupport() {
        }

        Log createLog() {
            return LogFactory.getLog(this.getClass());
        }

        @Override
        public SnapshotOptions<K, V> createOptions() {
            throw new UnsupportedOperationException("not implemented");
        }

        protected SnapshotOptions<K, V> createOptions(SnapshotMetadata<K, V> metadata) {
            return this.createOptions().invokeCallbacks(metadata.isInvokeCallbacks()).setFilter(metadata.getFilter()).setParallelMode(metadata.isParallel());
        }

        @Override
        public void doExport(SnapshotMetadata<K, V> ... configurations) {
            Arrays.stream(SnapshotServiceFactoryBean.nullSafeArray(configurations)).forEach(configuration -> this.save(configuration.getLocation(), configuration.getFormat(), this.createOptions((SnapshotMetadata<K, V>)configuration)));
        }

        @Override
        public void doImport(SnapshotMetadata<K, V> ... configurations) {
            Arrays.stream(SnapshotServiceFactoryBean.nullSafeArray(configurations)).forEach(configuration -> this.load(configuration.getFormat(), this.createOptions((SnapshotMetadata<K, V>)configuration), this.handleLocation((SnapshotMetadata<K, V>)configuration)));
        }

        protected abstract File[] handleLocation(SnapshotMetadata<K, V> var1);

        protected File[] handleDirectoryLocation(File directory) {
            return directory.listFiles(SnapshotServiceFactoryBean::nullSafeIsFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File[] handleFileLocation(File file) {
            if (ArchiveFileFilter.INSTANCE.accept(file)) {
                try {
                    File extractedArchiveDirectory = new File(TEMPORARY_DIRECTORY, file.getName().replaceAll("\\.", "-"));
                    Assert.state((extractedArchiveDirectory.isDirectory() || extractedArchiveDirectory.mkdirs() ? 1 : 0) != 0, (String)String.format("Failed create directory (%1$s) in which to extract archive (%2$s)", extractedArchiveDirectory, file));
                    ZipFile zipFile = ArchiveFileFilter.INSTANCE.isJarFile(file) ? new JarFile(file, false, 1) : new ZipFile(file, 1);
                    for (ZipEntry zipEntry : CollectionUtils.iterable(zipFile.entries())) {
                        if (zipEntry.isDirectory()) continue;
                        DataInputStream entryInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
                        DataOutputStream entryOutputStream = new DataOutputStream(new FileOutputStream(new File(extractedArchiveDirectory, this.toSimpleFilename(zipEntry.getName()))));
                        try {
                            FileCopyUtils.copy((InputStream)entryInputStream, (OutputStream)entryOutputStream);
                        }
                        finally {
                            this.exceptionSuppressingClose(entryInputStream);
                            this.exceptionSuppressingClose(entryOutputStream);
                        }
                    }
                    return this.handleDirectoryLocation(extractedArchiveDirectory);
                }
                catch (Throwable cause) {
                    throw new ImportSnapshotException(String.format("Failed to extract archive [%1$s] to import", file), cause);
                }
            }
            return new File[]{file};
        }

        protected boolean exceptionSuppressingClose(Closeable closeable) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException cause) {
                this.logDebug(cause, "Failed to close [%s]", closeable);
                return false;
            }
        }

        protected void logDebug(Throwable cause, String message, Object ... arguments) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format(message, arguments), cause);
            }
        }

        @Override
        public void load(File directory, SnapshotOptions.SnapshotFormat format) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options, File ... snapshots) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void save(File location, SnapshotOptions.SnapshotFormat format) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void save(File location, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            throw new UnsupportedOperationException("not implemented");
        }

        protected String toSimpleFilename(String pathname) {
            int pathSeparatorIndex = String.valueOf(pathname).lastIndexOf(File.separator);
            pathname = pathSeparatorIndex > -1 ? pathname.substring(pathSeparatorIndex + 1) : pathname;
            return StringUtils.trimWhitespace((String)pathname);
        }
    }

    public static interface SnapshotServiceAdapter<K, V> {
        public SnapshotOptions<K, V> createOptions();

        public void doExport(SnapshotMetadata<K, V> ... var1);

        public void doImport(SnapshotMetadata<K, V> ... var1);

        public void load(File var1, SnapshotOptions.SnapshotFormat var2);

        public void load(SnapshotOptions.SnapshotFormat var1, SnapshotOptions<K, V> var2, File ... var3);

        public void save(File var1, SnapshotOptions.SnapshotFormat var2);

        public void save(File var1, SnapshotOptions.SnapshotFormat var2, SnapshotOptions<K, V> var3);
    }
}

