/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Arrays;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

public class PdxDiskStoreAwareBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String pdxDiskStoreName;

    public PdxDiskStoreAwareBeanFactoryPostProcessor(String pdxDiskStoreName) {
        Assert.hasText((String)pdxDiskStoreName, (String)"PDX DiskStore name is required");
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.postProcessPdxDiskStoreDependencies(beanFactory, AsyncEventQueue.class, DiskStore.class, Region.class);
    }

    private void postProcessPdxDiskStoreDependencies(ConfigurableListableBeanFactory beanFactory, Class<?> ... beanTypes) {
        Arrays.stream(ArrayUtils.nullSafeArray(beanTypes, Class.class)).forEach(beanType -> {
            for (String beanName : beanFactory.getBeanNamesForType(beanType)) {
                if (beanName.equalsIgnoreCase(this.getPdxDiskStoreName())) continue;
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                this.addPdxDiskStoreDependency(beanDefinition);
            }
        });
    }

    private void addPdxDiskStoreDependency(BeanDefinition beanDefinition) {
        String[] newDependsOn = (String[])ArrayUtils.insert(this.getDependsOn(beanDefinition), 0, this.getPdxDiskStoreName());
        beanDefinition.setDependsOn(newDependsOn);
    }

    private String[] getDependsOn(BeanDefinition beanDefinition) {
        return SpringUtils.defaultIfNull(beanDefinition.getDependsOn(), EMPTY_STRING_ARRAY);
    }
}

