/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Hashtable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.ra.GFConnection;
import org.apache.geode.ra.GFConnectionFactory;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class AbstractGemFireAsLastResourceAspectSupport
implements Ordered {
    protected static final boolean DEFAULT_THROW_ON_ERROR = false;
    protected static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    protected static final Consumer<String> NO_OP_LOGGER = message -> {};
    protected static final String DEFAULT_GEMFIRE_JCA_RESOURCE_ADAPTER_JNDI_NAME = "gfe/jca";
    private boolean throwOnError = false;
    private int order = Integer.MAX_VALUE;
    @Autowired(required=false)
    private Context context;
    @Autowired(required=false)
    private GemFireCache gemfireCache;
    private final Logger logger = this.newLogger();
    @Value(value="${spring.data.gemfire.jca.resource-adapter.jndi.name:gfe/jca}")
    private String gemfireJcaResourceAdapterJndiName;
    @Value(value="${spring.data.gemfire.naming.context.factory:}")
    private String initialContextFactory;
    @Value(value="${spring.data.gemfire.naming.context.provider-url:}")
    private String providerUrl;

    protected synchronized Context getContext() {
        return this.context;
    }

    protected synchronized <T extends GemFireCache> T getGemFireCache() {
        return (T)this.gemfireCache;
    }

    public String getGemFireJcaResourceAdapterJndiName() {
        return this.gemfireJcaResourceAdapterJndiName;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return Optional.of(this.order).filter(order -> order != Integer.MAX_VALUE && order != Integer.MIN_VALUE).orElseGet(this::getDefaultOrder);
    }

    protected Integer getDefaultOrder() {
        return Integer.MAX_VALUE;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public boolean isThrowOnError() {
        return this.throwOnError;
    }

    @Pointcut(value="@within(org.springframework.transaction.annotation.Transactional)")
    protected void atTransactionalType() {
    }

    @Pointcut(value="@annotation(org.springframework.transaction.annotation.Transactional)")
    protected void atTransactionalMethod() {
    }

    protected String format(String message, Object ... args) {
        return String.format(message, args);
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logDebugInfo(String message, Object ... args) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.format(message, args), args);
        }
        return (T)this;
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logInfo(String message, Object ... args) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info(this.format(message, args), args);
        }
        return (T)this;
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logTraceInfo(String message, Object ... args) {
        return this.logTraceInfo(() -> this.format(message, args));
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logTraceInfo(Supplier<String> logMessage) {
        Logger logger = this.getLogger();
        if (logger.isTraceEnabled()) {
            logger.trace(logMessage.get());
        }
        return (T)this;
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logWarning(String message, Object ... args) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            logger.warn(this.format(message, args), args);
        }
        return (T)this;
    }

    protected <T extends AbstractGemFireAsLastResourceAspectSupport> T logError(String message, Object ... args) {
        Logger logger = this.getLogger();
        if (logger.isErrorEnabled()) {
            logger.error(this.format(message, args), args);
        }
        return (T)this;
    }

    protected InitialContext newInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return new InitialContext(environment);
    }

    protected Logger newLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected synchronized Context resolveContext() {
        Context context = this.getContext();
        if (context == null) {
            Hashtable<?, ?> resolvedEnvironment = this.resolveEnvironment();
            try {
                context = this.context = this.newInitialContext(resolvedEnvironment);
            }
            catch (NamingException cause) {
                context = this.context = Optional.ofNullable(this.resolveGemFireCache()).map(GemFireCache::getJNDIContext).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException(cause, "Failed to initialize an %1$s with the provided Environment configuration ['%2$s']", InitialContext.class.getName(), resolvedEnvironment));
            }
        }
        return context;
    }

    protected Hashtable<?, ?> resolveEnvironment() {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", this.getInitialContextFactory());
        environment.put("java.naming.provider.url", this.getProviderUrl());
        return environment;
    }

    protected synchronized GemFireCache resolveGemFireCache() {
        Object gemfireCache = this.getGemFireCache();
        if (gemfireCache == null) {
            this.gemfireCache = GemfireUtils.resolveGemFireCache();
            gemfireCache = this.gemfireCache;
        }
        return gemfireCache;
    }

    protected String resolveGemFireJcaResourceAdapterJndiName() {
        String gemfireJcaResourceAdapterJndiName = this.getGemFireJcaResourceAdapterJndiName();
        return StringUtils.hasText((String)gemfireJcaResourceAdapterJndiName) ? gemfireJcaResourceAdapterJndiName : DEFAULT_GEMFIRE_JCA_RESOURCE_ADAPTER_JNDI_NAME;
    }

    public <T extends AbstractGemFireAsLastResourceAspectSupport> T withThrowOnError(boolean throwOnError) {
        this.throwOnError = throwOnError;
        return (T)this;
    }

    protected static class GemFireConnectionHolder {
        private static final ThreadLocal<GFConnection> gemfireConnection = new ThreadLocal();

        protected GemFireConnectionHolder() {
        }

        public static GFConnection acquire(GFConnectionFactory connectionFactory) {
            return GemFireConnectionHolder.acquire(connectionFactory, false, NO_OP_LOGGER);
        }

        public static GFConnection acquire(GFConnectionFactory connectionFactory, boolean throwOnError, Consumer<String> logger) {
            try {
                return GemFireConnectionHolder.of(connectionFactory.getConnection());
            }
            catch (ResourceException cause) {
                String message = String.format("Failed to acquire Pivotal GemFire Connection from GemFire's JCA ResourceAdapter: %s", cause.getMessage());
                if (throwOnError) {
                    throw RuntimeExceptionFactory.newRuntimeException(cause, message, new Object[0]);
                }
                logger.accept(message);
                return null;
            }
        }

        public static GFConnection of(GFConnection connection) {
            gemfireConnection.set(connection);
            return connection;
        }

        public static Optional<GFConnection> get() {
            return Optional.ofNullable(gemfireConnection.get());
        }

        public static void close() {
            GemFireConnectionHolder.close(false, NO_OP_LOGGER);
        }

        public static void close(boolean throwOnError, Consumer<String> logger) {
            GemFireConnectionHolder.get().ifPresent(connection -> {
                try {
                    connection.close();
                }
                catch (ResourceException cause) {
                    String message = String.format("Failed to close Pivotal GemFire Connection: %s", cause.getMessage());
                    if (throwOnError) {
                        throw RuntimeExceptionFactory.newRuntimeException(cause, message, new Object[0]);
                    }
                    logger.accept(message);
                }
            });
        }
    }
}

