/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionShortcut;
import org.springframework.util.ObjectUtils;

public enum RegionShortcutWrapper {
    LOCAL(RegionShortcut.LOCAL, DataPolicy.NORMAL),
    LOCAL_HEAP_LRU(RegionShortcut.LOCAL_HEAP_LRU, DataPolicy.NORMAL),
    LOCAL_OVERFLOW(RegionShortcut.LOCAL_OVERFLOW, DataPolicy.NORMAL),
    LOCAL_PERSISTENT(RegionShortcut.LOCAL_PERSISTENT, DataPolicy.PERSISTENT_REPLICATE),
    LOCAL_PERSISTENT_OVERFLOW(RegionShortcut.LOCAL_PERSISTENT_OVERFLOW, DataPolicy.PERSISTENT_REPLICATE),
    PARTITION(RegionShortcut.PARTITION, DataPolicy.PARTITION),
    PARTITION_HEAP_LRU(RegionShortcut.PARTITION_HEAP_LRU, DataPolicy.PARTITION),
    PARTITION_OVERFLOW(RegionShortcut.PARTITION_OVERFLOW, DataPolicy.PARTITION),
    PARTITION_PERSISTENT(RegionShortcut.PARTITION_PERSISTENT, DataPolicy.PERSISTENT_PARTITION),
    PARTITION_PERSISTENT_OVERFLOW(RegionShortcut.PARTITION_PERSISTENT_OVERFLOW, DataPolicy.PERSISTENT_PARTITION),
    PARTITION_PROXY(RegionShortcut.PARTITION_PROXY, DataPolicy.PARTITION),
    PARTITION_PROXY_REDUNDANT(RegionShortcut.PARTITION_PROXY_REDUNDANT, DataPolicy.PARTITION),
    PARTITION_REDUNDANT(RegionShortcut.PARTITION_REDUNDANT, DataPolicy.PARTITION),
    PARTITION_REDUNDANT_HEAP_LRU(RegionShortcut.PARTITION_REDUNDANT_HEAP_LRU, DataPolicy.PARTITION),
    PARTITION_REDUNDANT_OVERFLOW(RegionShortcut.PARTITION_REDUNDANT_OVERFLOW, DataPolicy.PARTITION),
    PARTITION_REDUNDANT_PERSISTENT(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT, DataPolicy.PERSISTENT_PARTITION),
    PARTITION_REDUNDANT_PERSISTENT_OVERFLOW(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT_OVERFLOW, DataPolicy.PERSISTENT_PARTITION),
    REPLICATE(RegionShortcut.REPLICATE, DataPolicy.REPLICATE),
    REPLICATE_HEAP_LRU(RegionShortcut.REPLICATE_HEAP_LRU, DataPolicy.REPLICATE),
    REPLICATE_OVERFLOW(RegionShortcut.REPLICATE_OVERFLOW, DataPolicy.REPLICATE),
    REPLICATE_PERSISTENT(RegionShortcut.REPLICATE_PERSISTENT, DataPolicy.PERSISTENT_REPLICATE),
    REPLICATE_PERSISTENT_OVERFLOW(RegionShortcut.REPLICATE_PERSISTENT_OVERFLOW, DataPolicy.PERSISTENT_REPLICATE),
    REPLICATE_PROXY(RegionShortcut.REPLICATE_PROXY, DataPolicy.EMPTY),
    UNSPECIFIED(null, null);

    private final DataPolicy dataPolicy;
    private final RegionShortcut regionShortcut;

    private RegionShortcutWrapper(RegionShortcut regionShortcut, DataPolicy dataPolicy) {
        this.regionShortcut = regionShortcut;
        this.dataPolicy = dataPolicy;
    }

    public static RegionShortcutWrapper valueOf(RegionShortcut regionShortcut) {
        for (RegionShortcutWrapper wrapper : RegionShortcutWrapper.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)wrapper.getRegionShortcut(), (Object)regionShortcut)) continue;
            return wrapper;
        }
        return UNSPECIFIED;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public RegionShortcut getRegionShortcut() {
        return this.regionShortcut;
    }

    public boolean isHeapLru() {
        return this.name().contains("HEAP_LRU");
    }

    public boolean isLocal() {
        return this.name().contains("LOCAL");
    }

    public boolean isOverflow() {
        return this.name().contains("OVERFLOW");
    }

    public boolean isPartition() {
        return this.name().contains("PARTITION");
    }

    public boolean isPersistent() {
        return this.name().contains("PERSISTENT");
    }

    public boolean isPersistentOverflow() {
        return this.isOverflow() && this.isPersistent();
    }

    public boolean isProxy() {
        return this.name().contains("PROXY");
    }

    public boolean isRedundant() {
        return this.name().contains("REDUNDANT");
    }

    public boolean isReplicate() {
        return this.name().contains("REPLICATE");
    }
}

