/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.Arrays;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.RegionAttributes;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.IndexMaintenancePolicyType;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public class RegionAttributesFactoryBean<K, V>
extends AttributesFactory<K, V>
implements FactoryBean<RegionAttributes>,
InitializingBean {
    private RegionAttributes<K, V> regionAttributes;

    public void afterPropertiesSet() throws Exception {
        this.regionAttributes = super.create();
    }

    public RegionAttributes<K, V> getObject() throws Exception {
        return this.regionAttributes;
    }

    public Class<?> getObjectType() {
        return this.regionAttributes != null ? this.regionAttributes.getClass() : RegionAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAsyncEventQueueIds(String[] asyncEventQueueIds) {
        Arrays.stream(ArrayUtils.nullSafeArray(asyncEventQueueIds, String.class)).filter(StringUtils::hasText).map(String::trim).forEach(arg_0 -> ((RegionAttributesFactoryBean)this).addAsyncEventQueueId(arg_0));
    }

    public void setIndexUpdateType(IndexMaintenancePolicyType indexUpdateType) {
        indexUpdateType.setIndexMaintenance(this);
    }

    public void setGatewaySenderIds(String[] gatewaySenderIds) {
        Arrays.stream(ArrayUtils.nullSafeArray(gatewaySenderIds, String.class)).filter(StringUtils::hasText).map(String::trim).forEach(arg_0 -> ((RegionAttributesFactoryBean)this).addGatewaySenderId(arg_0));
    }
}

