/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.remote;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.client.ClientCache;
import org.springframework.data.gemfire.config.admin.remote.FunctionGemfireAdminTemplate;
import org.springframework.data.gemfire.config.schema.definitions.IndexDefinition;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.NetworkUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RestHttpGemfireAdminTemplate
extends FunctionGemfireAdminTemplate {
    protected static final boolean DEFAULT_CREATE_REGION_SKIP_IF_EXISTS = true;
    protected static final boolean DEFAULT_HTTP_FOLLOW_REDIRECTS = true;
    protected static final int DEFAULT_PORT = -1;
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String DEFAULT_SCHEME = "https";
    protected static final String HTTP_SCHEME = "http";
    protected static final String HTTPS_SCHEME = "https";
    protected static final String MANAGEMENT_REST_API_URL_TEMPLATE = "%1$s://%2$s:%3$d/gemfire/v1";
    protected static final String MANAGEMENT_REST_API_NO_PORT_URL_TEMPLATE = "%1$s://%2$s/gemfire/v1";
    protected static final List<String> VALID_SCHEMES = Arrays.asList("http", "https");
    private final RestOperations restTemplate;
    private final String managementRestApiUrl;

    public RestHttpGemfireAdminTemplate(ClientCache clientCache) {
        this(clientCache, "https", DEFAULT_HOST, -1, true, Collections.emptyList());
    }

    public RestHttpGemfireAdminTemplate(ClientCache clientCache, String scheme, String host, int port, boolean followRedirects, List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors) {
        super(clientCache);
        Object clientHttpRequestFactory = this.newClientHttpRequestFactory(followRedirects);
        this.managementRestApiUrl = this.resolveManagementRestApiUrl(scheme, host, port);
        this.restTemplate = this.newRestOperations((ClientHttpRequestFactory)clientHttpRequestFactory, clientHttpRequestInterceptors);
    }

    protected <T extends ClientHttpRequestFactory> T newClientHttpRequestFactory(boolean followRedirects) {
        return (T)((Object)new FollowRedirectsSimpleClientHttpRequestFactory(followRedirects));
    }

    protected <T extends RestOperations> T newRestOperations(ClientHttpRequestFactory clientHttpRequestFactory, List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors) {
        RestTemplate restTemplate = new RestTemplate(clientHttpRequestFactory);
        Optional.ofNullable(clientHttpRequestInterceptors).ifPresent(restTemplate.getInterceptors()::addAll);
        return (T)restTemplate;
    }

    String resolveManagementRestApiUrl(String scheme, String host, int port) {
        return NetworkUtils.isValidNonEphemeralPort(port) ? String.format(MANAGEMENT_REST_API_URL_TEMPLATE, scheme, host, port) : String.format(MANAGEMENT_REST_API_NO_PORT_URL_TEMPLATE, scheme, host);
    }

    protected String getManagementRestApiUrl() {
        return this.managementRestApiUrl;
    }

    protected <T extends RestOperations> T getRestOperations() {
        return (T)this.restTemplate;
    }

    @Override
    public void createIndex(IndexDefinition indexDefinition) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap httpRequestParameters = new LinkedMultiValueMap();
        httpRequestParameters.add((Object)"name", (Object)indexDefinition.getName());
        httpRequestParameters.add((Object)"expression", (Object)indexDefinition.getExpression());
        httpRequestParameters.add((Object)"region", (Object)indexDefinition.getFromClause());
        httpRequestParameters.add((Object)"type", (Object)indexDefinition.getIndexType().toString());
        RequestEntity requestEntity = new RequestEntity((Object)httpRequestParameters, (MultiValueMap)httpHeaders, HttpMethod.POST, this.resolveCreateIndexUri());
        ResponseEntity response = this.getRestOperations().exchange(requestEntity, String.class);
        HttpStatus.OK.equals((Object)response.getStatusCode());
    }

    protected URI resolveCreateIndexUri() {
        return URI.create(this.getManagementRestApiUrl().concat("/indexes"));
    }

    @Override
    public void createRegion(RegionDefinition regionDefinition) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap httpRequestParameters = new LinkedMultiValueMap();
        httpRequestParameters.add((Object)"name", (Object)regionDefinition.getName());
        httpRequestParameters.add((Object)"type", (Object)regionDefinition.getRegionShortcut().toString());
        httpRequestParameters.add((Object)"skip-if-exists", (Object)String.valueOf(true));
        RequestEntity requestEntity = new RequestEntity((Object)httpRequestParameters, (MultiValueMap)httpHeaders, HttpMethod.POST, this.resolveCreateRegionUri());
        ResponseEntity response = this.getRestOperations().exchange(requestEntity, String.class);
        HttpStatus.OK.equals((Object)response.getStatusCode());
    }

    protected URI resolveCreateRegionUri() {
        return URI.create(this.getManagementRestApiUrl().concat("/regions"));
    }

    public static class FollowRedirectsSimpleClientHttpRequestFactory
    extends SimpleClientHttpRequestFactory {
        private final boolean followRedirects;

        public FollowRedirectsSimpleClientHttpRequestFactory(boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public boolean isFollowRedirects() {
            return this.followRedirects;
        }

        protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
            super.prepareConnection(connection, httpMethod);
            connection.setInstanceFollowRedirects(this.isFollowRedirects());
        }
    }

    public static class Builder {
        private boolean followRedirects = true;
        private int port = -1;
        private ClientCache clientCache;
        private final List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors = new ArrayList<ClientHttpRequestInterceptor>();
        private String hostname = "localhost";
        private String scheme = "https";

        public Builder followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder listenOn(int port) {
            Assert.isTrue((boolean)NetworkUtils.isValidNonEphemeralPort(port), (String)String.format("Port [%d] must be greater than 0 and less than 65536", port));
            this.port = port;
            return this;
        }

        public Builder on(String hostname) {
            this.hostname = StringUtils.hasText((String)hostname) ? hostname : RestHttpGemfireAdminTemplate.DEFAULT_HOST;
            return this;
        }

        public Builder using(String scheme) {
            scheme = String.valueOf(scheme).trim().toLowerCase();
            Assert.isTrue((boolean)VALID_SCHEMES.contains(scheme), (String)String.format("Scheme [%s] is not valid; must be 1 of %s", scheme, VALID_SCHEMES));
            this.scheme = scheme;
            return this;
        }

        public Builder with(ClientCache clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        public Builder with(ClientHttpRequestInterceptor ... clientHttpRequestInterceptors) {
            clientHttpRequestInterceptors = ArrayUtils.nullSafeArray(clientHttpRequestInterceptors, ClientHttpRequestInterceptor.class);
            return this.with(Arrays.asList(clientHttpRequestInterceptors));
        }

        public Builder with(List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors) {
            this.clientHttpRequestInterceptors.addAll(CollectionUtils.nullSafeList(clientHttpRequestInterceptors));
            return this;
        }

        public RestHttpGemfireAdminTemplate build() {
            return new RestHttpGemfireAdminTemplate(this.clientCache, this.scheme, this.hostname, this.port, this.followRedirects, this.clientHttpRequestInterceptors);
        }
    }
}

