/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.util.CollectionUtils;

@Aspect
public class JSONRegionAdvice {
    private boolean convertReturnedCollections = true;
    private boolean prettyPrint = false;
    private List<String> includedRegions;
    protected final Log log = LogFactory.getLog(JSONRegionAdvice.class);

    public void setConvertReturnedCollections(boolean convertReturnedCollections) {
        this.convertReturnedCollections = convertReturnedCollections;
    }

    public void setIncludedRegions(List<Region<?, ?>> regions) {
        this.includedRegions = new ArrayList<String>();
        for (Region<?, ?> region : regions) {
            this.includedRegions.add(region.getName());
        }
    }

    public void setIncludedRegionNames(List<String> regionNames) {
        this.includedRegions = regionNames;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.put(..)) || execution(* org.apache.geode.cache.Region.create(..)) ||execution(* org.apache.geode.cache.Region.putIfAbsent(..)) ||execution(* org.apache.geode.cache.Region.replace(..))")
    public Object put(ProceedingJoinPoint pjp) {
        boolean JSONRegion = this.isIncludedSONRegion(pjp.getTarget());
        Object returnValue = null;
        try {
            if (JSONRegion) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Object val = newArgs[1];
                newArgs[1] = this.convertArgumentToPdxInstance(val);
                returnValue = pjp.proceed(newArgs);
                this.log.debug((Object)("converting " + returnValue + " to JSON string"));
                returnValue = this.convertPdxInstanceToJSONString(returnValue);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.putAll(..))")
    public Object putAll(ProceedingJoinPoint pjp) {
        boolean JSONRegion = this.isIncludedSONRegion(pjp.getTarget());
        Object returnValue = null;
        try {
            if (JSONRegion) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Map val = (Map)newArgs[0];
                HashMap newArg = new HashMap();
                for (Map.Entry entry : val.entrySet()) {
                    newArg.put(entry.getKey(), this.convertArgumentToPdxInstance(entry.getValue()));
                }
                newArgs[0] = newArg;
                returnValue = pjp.proceed(newArgs);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.get(..)) || execution(* org.apache.geode.cache.Region.selectValue(..))|| execution(* org.apache.geode.cache.Region.remove(..))")
    public Object get(ProceedingJoinPoint pjp) {
        Object returnValue = null;
        try {
            if (this.isIncludedSONRegion(pjp.getTarget())) {
                returnValue = pjp.proceed();
                this.log.debug((Object)("converting " + returnValue + " to JSON string"));
                returnValue = this.convertPdxInstanceToJSONString(returnValue);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.getAll(..))")
    public Map<Object, Object> getAll(ProceedingJoinPoint pjp) {
        HashMap result = null;
        try {
            HashMap retVal = (HashMap)pjp.proceed();
            if (!this.convertReturnedCollections || CollectionUtils.isEmpty((Map)retVal) || !this.isIncludedSONRegion(pjp.getTarget())) {
                result = retVal;
            } else {
                result = new HashMap();
                for (Map.Entry entry : retVal.entrySet()) {
                    result.put(entry.getKey(), this.convertPdxInstanceToJSONString(entry.getValue()));
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return result;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.values(..))")
    public Collection<Object> values(ProceedingJoinPoint pjp) {
        ArrayList<PdxInstance> result = null;
        try {
            ArrayList<PdxInstance> retVal = (ArrayList<PdxInstance>)pjp.proceed();
            if (!this.convertReturnedCollections || CollectionUtils.isEmpty((Collection)retVal) || !this.isIncludedSONRegion(pjp.getTarget())) {
                result = retVal;
            } else {
                result = new ArrayList<PdxInstance>();
                for (Object e : retVal) {
                    result.add(this.convertArgumentToPdxInstance(e));
                }
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return result;
    }

    @Around(value="execution(* org.springframework.data.gemfire.GemfireOperations.find(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.findUnique(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.query(..))")
    public Object templateQuery(ProceedingJoinPoint pjp) {
        GemfireTemplate template = (GemfireTemplate)pjp.getTarget();
        boolean jsonRegion = this.isIncludedSONRegion(template.getRegion());
        Object returnValue = null;
        try {
            if (jsonRegion) {
                returnValue = pjp.proceed();
                if (returnValue instanceof SelectResults && this.convertReturnedCollections) {
                    ResultsBag resultsBag = new ResultsBag();
                    for (Object obj : (SelectResults)returnValue) {
                        resultsBag.add(this.convertPdxInstanceToJSONString(obj));
                    }
                    returnValue = resultsBag;
                } else {
                    returnValue = this.convertPdxInstanceToJSONString(returnValue);
                }
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return returnValue;
    }

    private PdxInstance convertArgumentToPdxInstance(Object value) {
        PdxInstance pdx = null;
        if (value instanceof PdxInstance) {
            pdx = (PdxInstance)value;
        } else if (value instanceof String) {
            pdx = JSONFormatter.fromJSON((String)((String)value));
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String json = mapper.writeValueAsString(value);
                pdx = JSONFormatter.fromJSON((String)json);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }
        return pdx;
    }

    private boolean isIncludedSONRegion(Object target) {
        Region region = (Region)target;
        boolean result = false;
        if (this.includedRegions == null || this.includedRegions.contains(region.getName())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(region.getName() + " is included for JSON conversion"));
            }
            result = true;
        }
        return result;
    }

    private Object convertPdxInstanceToJSONString(Object returnValue) {
        Object result = returnValue;
        if (returnValue != null && returnValue instanceof PdxInstance) {
            result = JSONFormatter.toJSON((PdxInstance)((PdxInstance)returnValue));
            if (!this.prettyPrint) {
                result = this.flattenString(result);
            }
        }
        return result;
    }

    private Object flattenString(Object result) {
        if (result instanceof String) {
            String json = (String)result;
            return json.replaceAll("\\s*", "");
        }
        return result;
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }
}

