/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.DiskStoreFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableDiskStore;
import org.springframework.data.gemfire.util.ArrayUtils;

public class DiskStoreConfiguration
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnableDiskStore.class.getName())) {
            AnnotationAttributes enableDiskStoreAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableDiskStore.class.getName()));
            this.registerDiskStoreBeanDefinition(importingClassMetadata, enableDiskStoreAttributes, registry);
        }
    }

    protected void registerDiskStoreBeanDefinition(AnnotationMetadata importingClassMetadata, AnnotationAttributes enableDiskStoreAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder diskStoreFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskStoreFactoryBean.class);
        String diskStoreName = enableDiskStoreAttributes.getString("name");
        diskStoreFactoryBeanBuilder.addPropertyValue("beanName", (Object)diskStoreName);
        diskStoreFactoryBeanBuilder.addPropertyReference("cache", "gemfireCache");
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "allowForceCompaction", enableDiskStoreAttributes.getBoolean("allowForceCompaction"), false);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "autoCompact", enableDiskStoreAttributes.getBoolean("autoCompact"), false);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "compactionThreshold", enableDiskStoreAttributes.getNumber("compactionThreshold"), 50);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "diskUsageCriticalPercentage", enableDiskStoreAttributes.getNumber("diskUsageCriticalPercentage"), Float.valueOf(99.0f));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "diskUsageWarningPercentage", enableDiskStoreAttributes.getNumber("diskUsageWarningPercentage"), Float.valueOf(90.0f));
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "maxOplogSize", enableDiskStoreAttributes.getNumber("maxOplogSize"), 1024L);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "queueSize", enableDiskStoreAttributes.getNumber("queueSize"), 0);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "timeInterval", enableDiskStoreAttributes.getNumber("timeInterval"), 1000L);
        this.setPropertyValueIfNotDefault(diskStoreFactoryBeanBuilder, "writeBufferSize", enableDiskStoreAttributes.getNumber("writeBufferSize"), 32768);
        this.parseDiskStoreDiskDirectories(importingClassMetadata, enableDiskStoreAttributes, diskStoreFactoryBeanBuilder);
        registry.registerBeanDefinition(diskStoreName, (BeanDefinition)diskStoreFactoryBeanBuilder.getBeanDefinition());
    }

    protected BeanDefinitionBuilder parseDiskStoreDiskDirectories(AnnotationMetadata importingClassMetadata, AnnotationAttributes enableDiskStoreAttributes, BeanDefinitionBuilder diskStoreBeanFactoryBuilder) {
        AnnotationAttributes[] diskDirectories = ArrayUtils.nullSafeArray(enableDiskStoreAttributes.getAnnotationArray("diskDirectories"), AnnotationAttributes.class);
        ManagedList diskDirectoryBeans = new ManagedList(diskDirectories.length);
        for (AnnotationAttributes diskDirectoryAttributes : diskDirectories) {
            BeanDefinitionBuilder diskDirectoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(DiskStoreFactoryBean.DiskDir.class);
            diskDirectoryBuilder.addConstructorArgValue((Object)diskDirectoryAttributes.getString("location"));
            diskDirectoryBuilder.addConstructorArgValue((Object)diskDirectoryAttributes.getNumber("maxSize"));
            diskDirectoryBeans.add((Object)diskDirectoryBuilder.getBeanDefinition());
        }
        if (!diskDirectoryBeans.isEmpty()) {
            diskStoreBeanFactoryBuilder.addPropertyValue("diskDirs", (Object)diskDirectoryBeans);
        }
        return diskStoreBeanFactoryBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null && !value.equals(defaultValue) ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder;
    }
}

