/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import java.util.concurrent.ConcurrentMap;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.util.ClassUtils;

public abstract class GemfireUtils
extends CacheUtils {
    public static final String GEMFIRE_VERSION = CacheFactory.getVersion();

    public static boolean isGemfireVersionGreaterThanEqualTo(double expectedVersion) {
        double actualVersion = Double.parseDouble(GEMFIRE_VERSION.substring(0, 3));
        return actualVersion >= expectedVersion;
    }

    public static boolean isGemfireVersion65OrAbove() {
        try {
            double version = Double.parseDouble(GEMFIRE_VERSION.substring(0, 3));
            return version >= 6.5;
        }
        catch (NumberFormatException e) {
            return ConcurrentMap.class.isAssignableFrom(Region.class);
        }
    }

    public static boolean isGemfireVersion7OrAbove() {
        try {
            return GemfireUtils.isGemfireVersionGreaterThanEqualTo(7.0);
        }
        catch (NumberFormatException e) {
            return ClassUtils.isPresent((String)"com.gemstone.gemfire.distributed.ServerLauncher", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public static boolean isGemfireVersion8OrAbove() {
        try {
            return GemfireUtils.isGemfireVersionGreaterThanEqualTo(8.0);
        }
        catch (NumberFormatException e) {
            return ClassUtils.isPresent((String)"com.gemstone.gemfire.management.internal.web.domain.LinkIndex", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public static void main(String ... args) {
        System.out.printf("GemFire Version %1$s%n", GEMFIRE_VERSION);
    }
}

