/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import com.gemstone.gemfire.cache.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactory;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class GemfireRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Iterable<Region<?, ?>> regions;
    private MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext;

    public GemfireRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Collection regions = applicationContext.getBeansOfType(Region.class).values();
        this.regions = Collections.unmodifiableCollection(regions);
    }

    @Autowired(required=false)
    public void setGemfireMappingContext(MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> mappingContext) {
        this.setMappingContext(mappingContext);
        this.mappingContext = mappingContext;
    }

    protected MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> getGemfireMappingContext() {
        return this.mappingContext;
    }

    protected Iterable<Region<?, ?>> getRegions() {
        return this.regions;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        GemfireRepositoryFactory repositoryFactory = new GemfireRepositoryFactory(this.getRegions(), this.getGemfireMappingContext());
        if (this.applicationContext != null) {
            QueryPostProcessorRegistrationOnQueryCreationListener listener = new QueryPostProcessorRegistrationOnQueryCreationListener(this.applicationContext);
            repositoryFactory.addQueryCreationListener(listener);
        }
        return repositoryFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.getGemfireMappingContext() != null ? 1 : 0) != 0, (String)"GemfireMappingContext must not be null");
        super.afterPropertiesSet();
    }

    static class QueryPostProcessorMetadata {
        private static final Map<QueryPostProcessorKey, QueryPostProcessorMetadata> cache = new WeakHashMap<QueryPostProcessorKey, QueryPostProcessorMetadata>();
        private final Class<?> declaredRepositoryType;
        private final QueryPostProcessor<?, ?> queryPostProcessor;

        static synchronized QueryPostProcessorMetadata from(QueryPostProcessor<?, ?> queryPostProcessor) {
            QueryPostProcessorKey key = QueryPostProcessorKey.of(queryPostProcessor);
            QueryPostProcessorMetadata metadata = cache.get(key);
            if (metadata == null) {
                metadata = new QueryPostProcessorMetadata(key.getQueryPostProcessor());
                cache.put(key, metadata);
            }
            return metadata;
        }

        QueryPostProcessorMetadata(QueryPostProcessor<?, ?> queryPostProcessor) {
            Assert.notNull(queryPostProcessor, (String)"QueryPostProcessor must not be null");
            this.queryPostProcessor = queryPostProcessor;
            List typeArguments = ClassTypeInformation.from(queryPostProcessor.getClass()).getSuperTypeInformation(QueryPostProcessor.class).getTypeArguments();
            this.declaredRepositoryType = this.resolveDeclaredRepositoryType(typeArguments);
        }

        Class<?> resolveDeclaredRepositoryType(List<TypeInformation<?>> typeArguments) {
            return !CollectionUtils.nullSafeList(typeArguments).isEmpty() ? typeArguments.get(0).getType() : Repository.class;
        }

        Class<?> getDeclaredRepositoryType() {
            return this.declaredRepositoryType;
        }

        QueryPostProcessor<?, String> getQueryPostProcessor() {
            return this.queryPostProcessor;
        }

        boolean isMatch(Class<?> repositoryInterface) {
            return repositoryInterface != null && (this.getDeclaredRepositoryType().isAssignableFrom(repositoryInterface) || repositoryInterface.isAnnotationPresent(RepositoryDefinition.class));
        }

        GemfireRepositoryQuery register(GemfireRepositoryQuery repositoryQuery) {
            repositoryQuery.register(this.getQueryPostProcessor());
            return repositoryQuery;
        }

        protected static class QueryPostProcessorKey {
            private QueryPostProcessor<?, ?> queryPostProcessor;

            protected QueryPostProcessorKey() {
            }

            public static QueryPostProcessorKey of(QueryPostProcessor queryPostProcessor) {
                Assert.notNull((Object)queryPostProcessor, (String)"QueryPostProcessor must not be null");
                QueryPostProcessorKey key = new QueryPostProcessorKey();
                key.queryPostProcessor = queryPostProcessor;
                return key;
            }

            protected QueryPostProcessor<?, ?> getQueryPostProcessor() {
                return this.queryPostProcessor;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!(obj instanceof QueryPostProcessorKey)) {
                    return false;
                }
                QueryPostProcessorKey that = (QueryPostProcessorKey)obj;
                return this.getQueryPostProcessor().equals(that.getQueryPostProcessor());
            }

            public int hashCode() {
                int hashValue = 17;
                hashValue = 37 * hashValue + this.getQueryPostProcessor().hashCode();
                return hashValue;
            }
        }
    }

    protected class QueryPostProcessorRegistrationOnQueryCreationListener
    implements QueryCreationListener<GemfireRepositoryQuery> {
        private Iterable<QueryPostProcessorMetadata> queryPostProcessorsMetadata;

        protected QueryPostProcessorRegistrationOnQueryCreationListener(ApplicationContext applicationContext) {
            Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
            ArrayList queryPostProcessors = new ArrayList(applicationContext.getBeansOfType(QueryPostProcessor.class).values());
            Collections.sort(queryPostProcessors, OrderComparator.INSTANCE);
            ArrayList<QueryPostProcessorMetadata> queryPostProcessorsMetadata = new ArrayList<QueryPostProcessorMetadata>();
            for (QueryPostProcessor queryPostProcessor : queryPostProcessors) {
                queryPostProcessorsMetadata.add(QueryPostProcessorMetadata.from(queryPostProcessor));
            }
            this.queryPostProcessorsMetadata = queryPostProcessorsMetadata;
        }

        protected Iterable<QueryPostProcessorMetadata> getQueryPostProcessorsMetadata() {
            return this.queryPostProcessorsMetadata;
        }

        public void onCreation(GemfireRepositoryQuery repositoryQuery) {
            Class repositoryInterface = GemfireRepositoryFactoryBean.this.getRepositoryInformation().getRepositoryInterface();
            for (QueryPostProcessorMetadata metadata : this.getQueryPostProcessorsMetadata()) {
                if (!metadata.isMatch(repositoryInterface)) continue;
                metadata.register(repositoryQuery);
            }
        }
    }
}

