/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.listener.ContinuousQueryDefinition;
import org.springframework.data.gemfire.listener.ContinuousQueryListenerContainer;
import org.springframework.data.gemfire.listener.adapter.ContinuousQueryListenerAdapter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class GemfireListenerContainerParser
extends AbstractSingleBeanDefinitionParser {
    GemfireListenerContainerParser() {
    }

    protected Class<ContinuousQueryListenerContainer> getBeanClass(Element element) {
        return ContinuousQueryListenerContainer.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyReference(element, builder, "cache", "cache");
        ParsingUtils.setPropertyValue(element, builder, "auto-startup");
        ParsingUtils.setPropertyValue(element, builder, "phase");
        ParsingUtils.setPropertyValue(element, builder, "pool-name");
        ParsingUtils.setPropertyReference(element, builder, "error-handler", "errorHandler");
        ParsingUtils.setPropertyReference(element, builder, "task-executor", "taskExecutor");
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (!listenerElements.isEmpty()) {
            ManagedSet listeners = new ManagedSet(listenerElements.size());
            for (Element listenerElement : listenerElements) {
                listeners.add((Object)this.parseListener(listenerElement));
            }
            builder.addPropertyValue("queryListeners", (Object)listeners);
        }
    }

    private BeanDefinition parseListener(Element element) {
        BeanDefinitionBuilder continuousQueryListenerBuilder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryListenerAdapter.class);
        continuousQueryListenerBuilder.addConstructorArgReference(element.getAttribute("ref"));
        String attribute = element.getAttribute("method");
        if (StringUtils.hasText((String)attribute)) {
            continuousQueryListenerBuilder.addPropertyValue("defaultListenerMethod", (Object)attribute);
        }
        BeanDefinitionBuilder continuousQueryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ContinuousQueryDefinition.class);
        attribute = element.getAttribute("name");
        if (StringUtils.hasText((String)attribute)) {
            continuousQueryBuilder.addConstructorArgValue((Object)attribute);
        }
        continuousQueryBuilder.addConstructorArgValue((Object)element.getAttribute("query"));
        continuousQueryBuilder.addConstructorArgValue((Object)continuousQueryListenerBuilder.getBeanDefinition());
        attribute = element.getAttribute("durable");
        if (StringUtils.hasText((String)attribute)) {
            continuousQueryBuilder.addConstructorArgValue((Object)attribute);
        }
        return continuousQueryBuilder.getBeanDefinition();
    }
}

