/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.GemfireDataSourcePostProcessor;
import org.springframework.data.gemfire.config.xml.ClientCacheParser;
import org.springframework.data.gemfire.config.xml.PoolParser;
import org.w3c.dom.Element;

class GemfireDataSourceParser
extends AbstractBeanDefinitionParser {
    static final String SUBSCRIPTION_ENABLED_ATTRIBUTE_NAME = "subscription-enabled";
    static final String SUBSCRIPTION_ENABLED_PROPERTY_NAME = "subscriptionEnabled";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    GemfireDataSourceParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinition clientCacheDefinition = new ClientCacheParser().parse(element, parserContext);
        parserContext.getRegistry().registerBeanDefinition("gemfireCache", clientCacheDefinition);
        BeanDefinition poolDefinition = new PoolParser().parse(element, parserContext);
        MutablePropertyValues poolProperties = poolDefinition.getPropertyValues();
        if (!element.hasAttribute(SUBSCRIPTION_ENABLED_ATTRIBUTE_NAME)) {
            poolProperties.add(SUBSCRIPTION_ENABLED_PROPERTY_NAME, (Object)true);
        }
        parserContext.getRegistry().registerBeanDefinition("gemfirePool", poolDefinition);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Registered GemFire ClientCache bean [%1$s] of type [%2$s]%n", "gemfireCache", clientCacheDefinition.getBeanClassName()));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemfireDataSourcePostProcessor.class);
        builder.addConstructorArgReference("gemfireCache");
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return null;
    }
}

