/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.QueryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DefinedIndexesApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = this.initLogger();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            QueryService queryService = this.getQueryService(event);
            if (queryService != null) {
                queryService.createDefinedIndexes();
            }
        }
        catch (MultiIndexCreationException ignore) {
            this.logger.warn((Object)String.format("Failed to create pre-defined Indexes: %s", ignore.getMessage()), (Throwable)ignore);
        }
    }

    Log initLogger() {
        return LogFactory.getLog(this.getClass());
    }

    private QueryService getQueryService(ContextRefreshedEvent event) {
        String queryServiceBeanName;
        ApplicationContext applicationContext = event.getApplicationContext();
        return applicationContext.containsBean(queryServiceBeanName = this.getQueryServiceBeanName()) ? (QueryService)applicationContext.getBean(queryServiceBeanName, QueryService.class) : null;
    }

    private String getQueryServiceBeanName() {
        return "gemfireIndexDefinitionQueryService";
    }
}

