/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.EvictionActionType;
import org.springframework.data.gemfire.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.EvictionPolicyType;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableEviction;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public class EvictionConfiguration
implements ApplicationContextAware,
ImportAware {
    private ApplicationContext applicationContext;
    private EvictionPolicyConfigurer evictionPolicyConfigurer;

    protected static boolean isRegionFactoryBean(Object bean) {
        return bean instanceof RegionFactoryBean || bean instanceof ClientRegionFactoryBean;
    }

    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEviction.class;
    }

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (importMetadata.hasAnnotation(this.getAnnotationTypeName())) {
            Map enableEvictionAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            AnnotationAttributes[] policies = (AnnotationAttributes[])enableEvictionAttributes.get("policies");
            for (AnnotationAttributes evictionPolicyAttributes : ArrayUtils.nullSafeArray(policies, AnnotationAttributes.class)) {
                this.evictionPolicyConfigurer = ComposableEvictionPolicyConfigurer.compose(this.evictionPolicyConfigurer, EvictionPolicyMetaData.from(evictionPolicyAttributes, this.applicationContext));
            }
            this.evictionPolicyConfigurer = this.evictionPolicyConfigurer != null ? this.evictionPolicyConfigurer : EvictionPolicyMetaData.fromDefaults();
        }
    }

    protected EvictionPolicyConfigurer getEvictionPolicyConfigurer() {
        Assert.state((this.evictionPolicyConfigurer != null ? 1 : 0) != 0, (String)"EvictionPolicyConfigurer was not properly configured and initialized");
        return this.evictionPolicyConfigurer;
    }

    @Bean
    public BeanPostProcessor evictionBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return EvictionConfiguration.isRegionFactoryBean(bean) ? EvictionConfiguration.this.getEvictionPolicyConfigurer().configure(bean) : bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }

    protected static class EvictionPolicyMetaData
    implements EvictionPolicyConfigurer {
        protected static final String[] ALL_REGIONS = new String[0];
        private final EvictionAttributes evictionAttributes;
        private final Set<String> regionNames = new HashSet<String>();

        protected static EvictionPolicyMetaData from(AnnotationAttributes evictionPolicyAttributes, ApplicationContext applicationContext) {
            return EvictionPolicyMetaData.from((Integer)evictionPolicyAttributes.get((Object)"maximum"), (EvictionPolicyType)evictionPolicyAttributes.getEnum("type"), (EvictionActionType)evictionPolicyAttributes.getEnum("action"), EvictionPolicyMetaData.resolveObjectSizer(evictionPolicyAttributes.getString("objectSizerName"), applicationContext), evictionPolicyAttributes.getStringArray("regionNames"));
        }

        protected static EvictionPolicyMetaData from(EnableEviction.EvictionPolicy evictionPolicy, ApplicationContext applicationContext) {
            return EvictionPolicyMetaData.from(evictionPolicy.maximum(), evictionPolicy.type(), evictionPolicy.action(), EvictionPolicyMetaData.resolveObjectSizer(evictionPolicy.objectSizerName(), applicationContext), evictionPolicy.regionNames());
        }

        protected static EvictionPolicyMetaData from(int maximum, EvictionPolicyType type, EvictionActionType action, ObjectSizer objectSizer, String ... regionNames) {
            EvictionAttributesFactoryBean factoryBean = new EvictionAttributesFactoryBean();
            factoryBean.setAction(action.getEvictionAction());
            factoryBean.setObjectSizer(objectSizer);
            factoryBean.setThreshold(EvictionPolicyMetaData.resolveThreshold(maximum, type));
            factoryBean.setType(type);
            factoryBean.afterPropertiesSet();
            return new EvictionPolicyMetaData(factoryBean.getObject(), regionNames);
        }

        protected static EvictionPolicyMetaData fromDefaults() {
            return new EvictionPolicyMetaData(EvictionAttributes.createLRUEntryAttributes());
        }

        protected static ObjectSizer resolveObjectSizer(String objectSizerName, ApplicationContext applicationContext) {
            boolean resolvable = StringUtils.hasText((String)objectSizerName) && applicationContext.containsBean(objectSizerName);
            return resolvable ? (ObjectSizer)applicationContext.getBean(objectSizerName, ObjectSizer.class) : null;
        }

        protected static Integer resolveThreshold(int maximum, EvictionPolicyType type) {
            return EvictionPolicyType.HEAP_PERCENTAGE.equals((Object)type) ? null : Integer.valueOf(maximum);
        }

        protected EvictionPolicyMetaData(EvictionAttributes evictionAttributes) {
            this(evictionAttributes, ALL_REGIONS);
        }

        protected EvictionPolicyMetaData(EvictionAttributes evictionAttributes, String[] regionNames) {
            Assert.notNull((Object)evictionAttributes, (String)"EvictionAttributes must not be null");
            this.evictionAttributes = evictionAttributes;
            Collections.addAll(this.regionNames, ArrayUtils.nullSafeArray(regionNames, String.class));
        }

        protected EvictionAttributes getEvictionAttributes() {
            Assert.state((this.evictionAttributes != null ? 1 : 0) != 0, (String)"EvictionAttributes was not properly configured and initialized");
            return this.evictionAttributes;
        }

        protected boolean accepts(Object regionFactoryBean) {
            return EvictionConfiguration.isRegionFactoryBean(regionFactoryBean) && this.accepts(this.resolveRegionName(regionFactoryBean));
        }

        protected boolean accepts(String regionName) {
            return this.regionNames.isEmpty() || this.regionNames.contains(regionName);
        }

        protected String resolveRegionName(Object regionFactoryBean) {
            return regionFactoryBean instanceof RegionLookupFactoryBean ? ((RegionLookupFactoryBean)regionFactoryBean).resolveRegionName() : null;
        }

        protected Object setEvictionAttributes(Object regionFactoryBean) {
            if (regionFactoryBean instanceof RegionFactoryBean) {
                ((RegionFactoryBean)regionFactoryBean).setEvictionAttributes(this.getEvictionAttributes());
            } else {
                ((ClientRegionFactoryBean)regionFactoryBean).setEvictionAttributes(this.getEvictionAttributes());
            }
            return regionFactoryBean;
        }

        @Override
        public Object configure(Object regionFactoryBean) {
            return this.accepts(regionFactoryBean) ? this.setEvictionAttributes(regionFactoryBean) : regionFactoryBean;
        }
    }

    protected static class ComposableEvictionPolicyConfigurer
    implements EvictionPolicyConfigurer {
        private final EvictionPolicyConfigurer one;
        private final EvictionPolicyConfigurer two;

        protected static EvictionPolicyConfigurer compose(EvictionPolicyConfigurer[] array) {
            return ComposableEvictionPolicyConfigurer.compose(Arrays.asList(ArrayUtils.nullSafeArray(array, EvictionPolicyConfigurer.class)));
        }

        protected static EvictionPolicyConfigurer compose(Iterable<EvictionPolicyConfigurer> iterable) {
            EvictionPolicyConfigurer current = null;
            for (EvictionPolicyConfigurer evictionPolicyConfigurer : CollectionUtils.nullSafeIterable(iterable)) {
                current = ComposableEvictionPolicyConfigurer.compose(current, evictionPolicyConfigurer);
            }
            return current;
        }

        protected static EvictionPolicyConfigurer compose(EvictionPolicyConfigurer one, EvictionPolicyConfigurer two) {
            return one == null ? two : (two == null ? one : new ComposableEvictionPolicyConfigurer(one, two));
        }

        private ComposableEvictionPolicyConfigurer(EvictionPolicyConfigurer one, EvictionPolicyConfigurer two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public Object configure(Object regionFactoryBean) {
            return this.two.configure(this.one.configure(regionFactoryBean));
        }
    }

    protected static interface EvictionPolicyConfigurer {
        public Object configure(Object var1);
    }
}

