/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnablePool;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AddPoolConfiguration
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(EnablePool.class.getName())) {
            Map enablePoolAttributes = importingClassMetadata.getAnnotationAttributes(EnablePool.class.getName());
            this.registerPoolFactoryBeanDefinition(enablePoolAttributes, registry);
        }
    }

    protected void registerPoolFactoryBeanDefinition(Map<String, Object> enablePoolAttributes, BeanDefinitionRegistry registry) {
        String poolName = this.getAndValidatePoolName(enablePoolAttributes);
        BeanDefinitionBuilder poolFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(PoolFactoryBean.class);
        poolFactoryBean.addPropertyValue("freeConnectionTimeout", enablePoolAttributes.get("freeConnectionTimeout"));
        poolFactoryBean.addPropertyValue("idleTimeout", enablePoolAttributes.get("idleTimeout"));
        poolFactoryBean.addPropertyValue("loadConditioningInterval", enablePoolAttributes.get("loadConditioningInterval"));
        poolFactoryBean.addPropertyValue("maxConnections", enablePoolAttributes.get("maxConnections"));
        poolFactoryBean.addPropertyValue("minConnections", enablePoolAttributes.get("minConnections"));
        poolFactoryBean.addPropertyValue("multiUserAuthentication", enablePoolAttributes.get("multiUserAuthentication"));
        poolFactoryBean.addPropertyValue("pingInterval", enablePoolAttributes.get("pingInterval"));
        poolFactoryBean.addPropertyValue("prSingleHopEnabled", enablePoolAttributes.get("prSingleHopEnabled"));
        poolFactoryBean.addPropertyValue("readTimeout", enablePoolAttributes.get("readTimeout"));
        poolFactoryBean.addPropertyValue("retryAttempts", enablePoolAttributes.get("retryAttempts"));
        poolFactoryBean.addPropertyValue("serverGroup", enablePoolAttributes.get("serverGroup"));
        poolFactoryBean.addPropertyValue("socketBufferSize", enablePoolAttributes.get("socketBufferSize"));
        poolFactoryBean.addPropertyValue("statisticInterval", enablePoolAttributes.get("statisticInterval"));
        poolFactoryBean.addPropertyValue("subscriptionAckInterval", enablePoolAttributes.get("subscriptionAckInterval"));
        poolFactoryBean.addPropertyValue("subscriptionEnabled", enablePoolAttributes.get("subscriptionEnabled"));
        poolFactoryBean.addPropertyValue("subscriptionMessageTrackingTimeout", enablePoolAttributes.get("subscriptionMessageTrackingTimeout"));
        poolFactoryBean.addPropertyValue("subscriptionRedundancy", enablePoolAttributes.get("subscriptionRedundancy"));
        poolFactoryBean.addPropertyValue("threadLocalConnections", enablePoolAttributes.get("threadLocalConnections"));
        this.configurePoolConnections(enablePoolAttributes, poolFactoryBean);
        registry.registerBeanDefinition(poolName, (BeanDefinition)poolFactoryBean.getBeanDefinition());
    }

    protected String getAndValidatePoolName(Map<String, Object> enablePoolAttributes) {
        String poolName = (String)enablePoolAttributes.get("name");
        Assert.hasText((String)poolName, (String)"Pool name must be specified");
        return poolName;
    }

    protected BeanDefinitionBuilder configurePoolConnections(Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        this.configureLocators(enablePoolAttributes, poolFactoryBean);
        this.configureServers(enablePoolAttributes, poolFactoryBean);
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configureLocators(Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        poolFactoryBean.addPropertyValue("locators", (Object)this.parseConnectionEndpoints(enablePoolAttributes, "locators", "locatorsString", 10334));
        return poolFactoryBean;
    }

    protected BeanDefinitionBuilder configureServers(Map<String, Object> enablePoolAttributes, BeanDefinitionBuilder poolFactoryBean) {
        poolFactoryBean.addPropertyValue("servers", (Object)this.parseConnectionEndpoints(enablePoolAttributes, "servers", "serversString", 40404));
        return poolFactoryBean;
    }

    protected ConnectionEndpointList parseConnectionEndpoints(Map<String, Object> enablePoolAttributes, String arrayAttributeName, String stringAttributeName, int defaultPort) {
        AnnotationAttributes[] connectionEndpointsMetaData;
        ConnectionEndpointList connectionEndpoints = new ConnectionEndpointList();
        for (AnnotationAttributes annotationAttributes : connectionEndpointsMetaData = (AnnotationAttributes[])enablePoolAttributes.get(arrayAttributeName)) {
            connectionEndpoints.add(this.newConnectionEndpoint((String)annotationAttributes.get((Object)"host"), (Integer)annotationAttributes.get((Object)"port")));
        }
        String hostsPorts = (String)enablePoolAttributes.get(stringAttributeName);
        if (StringUtils.hasText((String)hostsPorts)) {
            connectionEndpoints.add(ConnectionEndpointList.parse(defaultPort, hostsPorts.split(",")));
        }
        return connectionEndpoints;
    }

    protected ConnectionEndpoint newConnectionEndpoint(String host, Integer port) {
        return new ConnectionEndpoint(host, port);
    }
}

