/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.GemfireRepository;
import org.springframework.data.gemfire.repository.Wrapper;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleGemfireRepository<T, ID extends Serializable>
implements GemfireRepository<T, ID> {
    private final GemfireTemplate template;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleGemfireRepository(GemfireTemplate template, EntityInformation<T, ID> entityInformation) {
        Assert.notNull((Object)template);
        Assert.notNull(entityInformation);
        this.template = template;
        this.entityInformation = entityInformation;
    }

    public <U extends T> U save(U entity) {
        this.template.put(this.entityInformation.getId(entity), entity);
        return entity;
    }

    public <U extends T> Iterable<U> save(Iterable<U> entities) {
        HashMap<Serializable, U> result = new HashMap<Serializable, U>();
        for (U entity : entities) {
            result.put(this.entityInformation.getId(entity), entity);
        }
        this.template.putAll(result);
        return result.values();
    }

    @Override
    public T save(Wrapper<T, ID> wrapper) {
        return this.template.put(wrapper.getKey(), wrapper.getEntity());
    }

    public long count() {
        SelectResults results = this.template.find("SELECT count(*) FROM " + this.template.getRegion().getFullPath(), new Object[0]);
        return ((Integer)results.iterator().next()).intValue();
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public T findOne(ID id) {
        return (T)this.template.get(id);
    }

    public Collection<T> findAll() {
        SelectResults results = this.template.find("SELECT * FROM " + this.template.getRegion().getFullPath(), new Object[0]);
        return results.asList();
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        QueryString query = new QueryString("SELECT * FROM /RegionPlaceholder").forRegion(this.entityInformation.getJavaType(), this.template.getRegion()).orderBy(sort);
        SelectResults selectResults = this.template.find(query.toString(), new Object[0]);
        return selectResults.asList();
    }

    public Collection<T> findAll(Iterable<ID> ids) {
        ArrayList<Serializable> parameters = new ArrayList<Serializable>();
        for (Serializable id : ids) {
            parameters.add(id);
        }
        return this.template.getAll(parameters).values();
    }

    public void delete(ID id) {
        this.template.remove(id);
    }

    public void delete(T entity) {
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    boolean isPartitioned(Region region) {
        return region != null && region.getAttributes() != null && this.isPartitioned(region.getAttributes().getDataPolicy());
    }

    boolean isPartitioned(DataPolicy dataPolicy) {
        return dataPolicy != null && dataPolicy.withPartitioning();
    }

    boolean isTransactionPresent(Region region) {
        return region.getRegionService() instanceof Cache && this.isTransactionPresent(((Cache)region.getRegionService()).getCacheTransactionManager());
    }

    boolean isTransactionPresent(CacheTransactionManager cacheTransactionManager) {
        return cacheTransactionManager != null && cacheTransactionManager.exists();
    }

    void doRegionClear(Region region) {
        for (Object key : region.keySet()) {
            region.remove(key);
        }
    }

    public void deleteAll() {
        this.template.execute(new GemfireCallback<Void>(){

            @Override
            public Void doInGemfire(Region region) {
                if (SimpleGemfireRepository.this.isPartitioned(region) || SimpleGemfireRepository.this.isTransactionPresent(region)) {
                    SimpleGemfireRepository.this.doRegionClear(region);
                } else {
                    try {
                        region.clear();
                    }
                    catch (UnsupportedOperationException ignore) {
                        SimpleGemfireRepository.this.doRegionClear(region);
                    }
                }
                return null;
            }
        });
    }
}

