/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.Declarable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class LazyWiringDeclarableSupport
implements ApplicationListener<ContextRefreshedEvent>,
Declarable,
DisposableBean {
    protected static final String BEAN_NAME_PARAMETER = "bean-name";
    private final AtomicReference<Properties> parametersReference = new AtomicReference();
    volatile boolean initialized = false;

    public LazyWiringDeclarableSupport() {
        SpringContextBootstrappingInitializer.register(this);
    }

    protected void assertInitialized() {
        Assert.state((boolean)this.isInitialized(), (String)String.format("This Declarable object (%1$s) has not been properly configured and initialized!", this.getClass().getName()));
    }

    protected void assertUninitialized() {
        Assert.state((!this.isInitialized() ? 1 : 0) != 0, (String)String.format("This Declarable object (%1$s) has already been configured and initialized, and is currently active!", this.getClass().getName()));
    }

    void doInit(ConfigurableListableBeanFactory beanFactory, Properties parameters) {
        BeanConfigurerSupport beanConfigurer = new BeanConfigurerSupport();
        beanConfigurer.setBeanFactory((BeanFactory)beanFactory);
        final String templateBeanName = parameters.getProperty(BEAN_NAME_PARAMETER);
        if (StringUtils.hasText((String)templateBeanName)) {
            if (beanFactory.containsBean(templateBeanName)) {
                beanConfigurer.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
                        return new BeanWiringInfo(templateBeanName);
                    }
                });
            } else {
                throw new IllegalArgumentException(String.format("No bean with name '%1$s' was found in the Spring context '%2$s'.", templateBeanName, beanFactory));
            }
        }
        beanConfigurer.afterPropertiesSet();
        beanConfigurer.configureBean((Object)this);
        beanConfigurer.destroy();
        this.initialized = true;
        this.doPostInit(parameters);
    }

    protected void doPostInit(Properties parameters) {
    }

    public final void init(Properties parameters) {
        this.assertUninitialized();
        this.parametersReference.set(parameters);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected Properties nullSafeGetParameters() {
        Properties parameters = this.parametersReference.get();
        return parameters != null ? parameters : new Properties();
    }

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        Assert.isTrue((boolean)(event.getApplicationContext() instanceof ConfigurableApplicationContext), (String)String.format("The Spring ApplicationContext (%1$s) must be an instance of ConfigurableApplicationContext.", ObjectUtils.nullSafeClassName((Object)event.getApplicationContext())));
        this.doInit(((ConfigurableApplicationContext)event.getApplicationContext()).getBeanFactory(), this.nullSafeGetParameters());
    }

    public void destroy() throws Exception {
        SpringContextBootstrappingInitializer.unregister(this);
        this.parametersReference.set(null);
        this.initialized = false;
    }
}

