/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.springframework.data.envers.repository.support.EnversRevisionEntityInformation;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionRevisionEntityInformation
implements EnversRevisionEntityInformation {
    private final Class<?> revisionEntityClass;
    private final Class<?> revisionNumberType;
    private final String revisionTimestampFieldName;

    public ReflectionRevisionEntityInformation(Class<?> revisionEntityClass) {
        Assert.notNull(revisionEntityClass, (String)"Revision entity type must not be null");
        AnnotationDetectionFieldCallback revisionNumberFieldCallback = new AnnotationDetectionFieldCallback(RevisionNumber.class);
        ReflectionUtils.doWithFields(revisionEntityClass, (ReflectionUtils.FieldCallback)revisionNumberFieldCallback);
        AnnotationDetectionFieldCallback revisionTimestampFieldCallback = new AnnotationDetectionFieldCallback(RevisionTimestamp.class);
        ReflectionUtils.doWithFields(revisionEntityClass, (ReflectionUtils.FieldCallback)revisionTimestampFieldCallback);
        this.revisionNumberType = revisionNumberFieldCallback.getRequiredType();
        this.revisionTimestampFieldName = revisionTimestampFieldCallback.getRequiredField().getName();
        this.revisionEntityClass = revisionEntityClass;
    }

    public boolean isDefaultRevisionEntity() {
        return false;
    }

    public Class<?> getRevisionEntityClass() {
        return this.revisionEntityClass;
    }

    public Class<?> getRevisionNumberType() {
        return this.revisionNumberType;
    }

    @Override
    public String getRevisionTimestampPropertyName() {
        return this.revisionTimestampFieldName;
    }
}

