/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Locale;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.WithConsistency;
import org.springframework.data.couchbase.repository.Collection;
import org.springframework.data.couchbase.repository.Query;
import org.springframework.data.couchbase.repository.ScanConsistency;
import org.springframework.data.couchbase.repository.Scope;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.util.StringUtils;

public class CouchbaseQueryMethod
extends QueryMethod {
    private final Method method;
    private final RepositoryMetadata repositoryMetadata;

    public CouchbaseQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext) {
        super(method, metadata, factory);
        this.method = method;
        this.repositoryMetadata = metadata;
    }

    public boolean hasN1qlAnnotation() {
        return this.getN1qlAnnotation() != null;
    }

    public Query getN1qlAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    public boolean hasInlineN1qlQuery() {
        return this.getInlineN1qlQuery() != null;
    }

    public boolean hasConsistencyAnnotation() {
        return this.getConsistencyAnnotation() != null;
    }

    public WithConsistency getConsistencyAnnotation() {
        return this.method.getAnnotation(WithConsistency.class);
    }

    public boolean hasScanConsistencyAnnotation() {
        return this.getScanConsistencyAnnotation() != null;
    }

    public ScanConsistency getScanConsistencyAnnotation() {
        AnnotatedElement[] annotated = new AnnotatedElement[]{this.method, this.method.getDeclaringClass(), this.repositoryMetadata.getRepositoryInterface(), this.repositoryMetadata.getDomainType()};
        return OptionsBuilder.annotation(ScanConsistency.class, "query", "_default", annotated);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, annotationClass);
    }

    public String getInlineN1qlQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getN1qlAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    public boolean isDeleteQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("delete");
    }

    public boolean isExistsQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("exists");
    }

    public boolean isCountQuery() {
        return this.getName().toLowerCase(Locale.ROOT).startsWith("count");
    }

    public String toString() {
        return super.toString();
    }

    public boolean hasReactiveWrapperParameter() {
        for (Parameter p : this.getParameters()) {
            if (!ReactiveWrapperConverters.supports((Class)p.getType())) continue;
            return true;
        }
        return false;
    }

    public String getCollection() {
        AnnotatedElement[] annotated = new AnnotatedElement[]{this.method, this.method.getDeclaringClass(), this.repositoryMetadata.getRepositoryInterface(), this.repositoryMetadata.getDomainType()};
        return OptionsBuilder.annotationString(Collection.class, "_default", annotated);
    }

    public String getScope() {
        AnnotatedElement[] annotated = new AnnotatedElement[]{this.method, this.method.getDeclaringClass(), this.repositoryMetadata.getRepositoryInterface(), this.repositoryMetadata.getDomainType()};
        return OptionsBuilder.annotationString(Scope.class, "_default", annotated);
    }
}

