/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.util.Assert;

@ReadingConverter
public class StringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    private final ObjectMapper objectMapper;

    public StringToEnumConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum(StringToEnumConverterFactory.getEnumType(targetType), this.objectMapper);
    }

    public static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return enumType;
    }

    private static class StringToEnum<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;
        private final ObjectMapper objectMapper;

        StringToEnum(Class<T> enumType, ObjectMapper objectMapper) {
            this.enumType = enumType;
            this.objectMapper = objectMapper;
        }

        public @Nullable T convert(String source) {
            if (source == null) {
                return null;
            }
            return (T)((Enum)this.objectMapper.convertValue((Object)source, this.enumType));
        }
    }
}

