/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.couchbase.core.mapping.CouchbaseList;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class CouchbaseSimpleTypes {
    public static final SimpleTypeHolder JSON_TYPES = new SimpleTypeHolder(Stream.of(JsonObject.class, JsonArray.class, Number.class).collect(Collectors.toSet()), true);
    public static final SimpleTypeHolder DOCUMENT_TYPES = new SimpleTypeHolder(Stream.of(CouchbaseDocument.class, CouchbaseList.class, Number.class).collect(Collectors.toSet()), true);
    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;
    private static final Set<Class<?>> COUCHBASE_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private CouchbaseSimpleTypes() {
    }

    static {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(String.class);
        classes.add(BigInteger.class);
        AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);
        HashSet<Class<Instant>> simpleTypes = new HashSet<Class<Instant>>();
        simpleTypes.add(Pattern.class);
        simpleTypes.add(UUID.class);
        simpleTypes.add(Instant.class);
        COUCHBASE_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(COUCHBASE_SIMPLE_TYPES, true){

            public boolean isSimpleType(Class<?> type) {
                if (type.isEnum()) {
                    return true;
                }
                if (type.getName().startsWith("java.time")) {
                    return false;
                }
                return super.isSimpleType(type);
            }
        };
    }
}

