/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

@FunctionalInterface
interface CouchbaseQueryExecution {
    public Object execute(Query var1, Class<?> var2, Class<?> var3, String var4);

    public static final class PagedExecution<FindWithQuery>
    implements CouchbaseQueryExecution {
        private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation;
        private final Pageable pageable;

        public PagedExecution(ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation, Pageable pageable) {
            Assert.notNull(operation, (String)"Operation must not be null!");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            this.operation = operation;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            int overallLimit = 0;
            Object matching = this.operation.as(returnType).matching(query);
            if (overallLimit != 0 && this.pageable.getOffset() + (long)this.pageable.getPageSize() > (long)overallLimit) {
                query.limit((int)((long)overallLimit - this.pageable.getOffset()));
            }
            return PageableExecutionUtils.getPage((List)matching.all(), (Pageable)this.pageable, () -> {
                long count = this.operation.matching(query.skip(-1L).limit(-1).withoutSort()).count();
                return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            });
        }
    }

    public static final class SlicedExecution
    implements CouchbaseQueryExecution {
        private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> find;
        private final Pageable pageable;

        public SlicedExecution(ExecutableFindByQueryOperation.ExecutableFindByQuery find, Pageable pageable) {
            Assert.notNull((Object)find, (String)"Find must not be null!");
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            this.find = find;
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            int pageSize = this.pageable.getPageSize();
            Query modifiedQuery = query.skip(this.pageable.getOffset()).limit(pageSize + 1);
            List result = this.find.as(returnType).matching(modifiedQuery).all();
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }

    public static final class ResultProcessingExecution
    implements CouchbaseQueryExecution {
        private final CouchbaseQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(CouchbaseQueryExecution delegate, Converter<Object, Object> converter) {
            Assert.notNull((Object)delegate, (String)"Delegate must not be null!");
            Assert.notNull(converter, (String)"Converter must not be null!");
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            return this.converter.convert(this.delegate.execute(query, type, returnType, collection));
        }
    }

    public static final class DeleteExecution
    implements CouchbaseQueryExecution {
        private final CouchbaseOperations operations;
        private final QueryMethod method;

        public DeleteExecution(CouchbaseOperations operations, QueryMethod method) {
            this.operations = operations;
            this.method = method;
        }

        @Override
        public Object execute(Query query, Class<?> type, Class<?> returnType, String collection) {
            return this.operations.removeByQuery(type).matching(query).all();
        }
    }
}

