/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.view.ViewScanConsistency;

public enum Consistency {
    READ_YOUR_OWN_WRITES(ViewScanConsistency.REQUEST_PLUS, QueryScanConsistency.REQUEST_PLUS),
    STRONGLY_CONSISTENT(ViewScanConsistency.REQUEST_PLUS, QueryScanConsistency.REQUEST_PLUS),
    UPDATE_AFTER(ViewScanConsistency.UPDATE_AFTER, QueryScanConsistency.NOT_BOUNDED),
    EVENTUALLY_CONSISTENT(ViewScanConsistency.UPDATE_AFTER, QueryScanConsistency.NOT_BOUNDED);

    public static final Consistency DEFAULT_CONSISTENCY;
    private final ViewScanConsistency viewConsistency;
    private final QueryScanConsistency n1qlConsistency;

    private Consistency(ViewScanConsistency viewConsistency, QueryScanConsistency n1qlConsistency) {
        this.viewConsistency = viewConsistency;
        this.n1qlConsistency = n1qlConsistency;
    }

    public ViewScanConsistency viewConsistency() {
        return this.viewConsistency;
    }

    public QueryScanConsistency n1qlConsistency() {
        return this.n1qlConsistency;
    }

    static {
        DEFAULT_CONSISTENCY = READ_YOUR_OWN_WRITES;
    }
}

