/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase;

import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.OwnedSupplier;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.util.function.Supplier;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;

public class SimpleCouchbaseClientFactory
implements CouchbaseClientFactory {
    private final Supplier<Cluster> cluster;
    private final Bucket bucket;
    private final Scope scope;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public SimpleCouchbaseClientFactory(String connectionString, Authenticator authenticator, String bucketName) {
        this(connectionString, authenticator, bucketName, null);
    }

    public SimpleCouchbaseClientFactory(String connectionString, Authenticator authenticator, String bucketName, String scopeName) {
        this((Supplier<Cluster>)new OwnedSupplier((Object)Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator))), bucketName, scopeName);
    }

    public SimpleCouchbaseClientFactory(String connectionString, Authenticator authenticator, String bucketName, String scopeName, ClusterEnvironment environment) {
        this((Supplier<Cluster>)new OwnedSupplier((Object)Cluster.connect((String)connectionString, (ClusterOptions)ClusterOptions.clusterOptions((Authenticator)authenticator).environment(environment))), bucketName, scopeName);
    }

    public SimpleCouchbaseClientFactory(Cluster cluster, String bucketName, String scopeName) {
        this(() -> cluster, bucketName, scopeName);
    }

    private SimpleCouchbaseClientFactory(Supplier<Cluster> cluster, String bucketName, String scopeName) {
        this.cluster = cluster;
        this.bucket = cluster.get().bucket(bucketName);
        this.scope = scopeName == null ? this.bucket.defaultScope() : this.bucket.scope(scopeName);
        this.exceptionTranslator = new CouchbaseExceptionTranslator();
    }

    @Override
    public CouchbaseClientFactory withScope(String scopeName) {
        return new SimpleCouchbaseClientFactory(this.cluster, this.bucket.name(), scopeName != null ? scopeName : this.getScope().name());
    }

    @Override
    public Cluster getCluster() {
        return this.cluster.get();
    }

    @Override
    public Bucket getBucket() {
        return this.bucket;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Collection getCollection(String collectionName) {
        Scope scope = this.getScope();
        if (collectionName == null) {
            if (!scope.name().equals("_default")) {
                throw new IllegalStateException("A collectionName must be provided if a non-default scope is used!");
            }
            return this.getBucket().defaultCollection();
        }
        return scope.collection(collectionName);
    }

    @Override
    public Collection getDefaultCollection() {
        return this.getCollection(null);
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    @Override
    public void close() {
        if (this.cluster instanceof OwnedSupplier) {
            this.cluster.get().disconnect();
        }
    }
}

