/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class ReactiveRepositoryOperationsMapping {
    private ReactiveCouchbaseOperations defaultOperations;
    private Map<String, ReactiveCouchbaseOperations> byRepository = new HashMap<String, ReactiveCouchbaseOperations>();
    private Map<String, ReactiveCouchbaseOperations> byEntity = new HashMap<String, ReactiveCouchbaseOperations>();

    public ReactiveRepositoryOperationsMapping(ReactiveCouchbaseOperations defaultOperations) {
        Assert.notNull((Object)defaultOperations, (String)"ReactiveCouchbaseOperations");
        this.defaultOperations = defaultOperations;
    }

    public ReactiveRepositoryOperationsMapping map(Class<?> repositoryInterface, ReactiveCouchbaseOperations operations) {
        this.byRepository.put(repositoryInterface.getName(), operations);
        return this;
    }

    public ReactiveRepositoryOperationsMapping mapEntity(Class<?> entityClass, ReactiveCouchbaseOperations operations) {
        this.byEntity.put(entityClass.getName(), operations);
        return this;
    }

    public ReactiveCouchbaseOperations getDefault() {
        return this.defaultOperations;
    }

    public ReactiveRepositoryOperationsMapping setDefault(ReactiveCouchbaseOperations aDefault) {
        Assert.notNull((Object)aDefault, (String)"ReactiveCouchbaseOperations");
        this.defaultOperations = aDefault;
        return this;
    }

    public MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> getMappingContext() {
        return this.defaultOperations.getConverter().getMappingContext();
    }

    public ReactiveCouchbaseOperations resolve(Class<?> repositoryInterface, Class<?> domainType) {
        ReactiveCouchbaseOperations result = this.byRepository.get(repositoryInterface.getName());
        if (result != null) {
            return result;
        }
        result = this.byEntity.get(domainType.getName());
        if (result != null) {
            return result;
        }
        return this.defaultOperations;
    }
}

