/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.util.Assert;

public class ExecutableRemoveByIdOperationSupport
implements ExecutableRemoveByIdOperation {
    private final CouchbaseTemplate template;

    public ExecutableRemoveByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById() {
        return new ExecutableRemoveByIdSupport(this.template, null, null, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE, null);
    }

    static class ExecutableRemoveByIdSupport
    implements ExecutableRemoveByIdOperation.ExecutableRemoveById {
        private final CouchbaseTemplate template;
        private final String scope;
        private final String collection;
        private final RemoveOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Long cas;
        private final ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport reactiveRemoveByIdSupport;

        ExecutableRemoveByIdSupport(CouchbaseTemplate template, String scope, String collection, RemoveOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Long cas) {
            this.template = template;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.reactiveRemoveByIdSupport = new ReactiveRemoveByIdOperationSupport.ReactiveRemoveByIdSupport(template.reactive(), scope, collection, options, persistTo, replicateTo, durabilityLevel, cas);
            this.cas = cas;
        }

        @Override
        public RemoveResult one(String id) {
            return (RemoveResult)this.reactiveRemoveByIdSupport.one(id).block();
        }

        @Override
        public List<RemoveResult> all(Collection<String> ids) {
            return (List)this.reactiveRemoveByIdSupport.all(ids).collectList().block();
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithOptions inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableRemoveByIdSupport(this.template, this.scope, collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInCollection withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInCollection withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.TerminatingRemoveById withOptions(RemoveOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableRemoveByIdSupport(this.template, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdInCollection inScope(String scope) {
            Assert.hasText((String)scope, (String)"Scope must not be null nor empty.");
            return new ExecutableRemoveByIdSupport(this.template, scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.cas);
        }

        @Override
        public ExecutableRemoveByIdOperation.RemoveByIdWithDurability withCas(Long cas) {
            return new ExecutableRemoveByIdSupport(this.template, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, cas);
        }
    }
}

