/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.util.Assert;

public class ExecutableRemoveByQueryOperationSupport
implements ExecutableRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final CouchbaseTemplate template;

    public ExecutableRemoveByQueryOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ExecutableRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED, null);
    }

    static class ExecutableRemoveByQuerySupport<T>
    implements ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T> reactiveSupport;
        private final QueryScanConsistency scanConsistency;
        private final String collection;

        ExecutableRemoveByQuerySupport(CouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency, String collection) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.reactiveSupport = new ReactiveRemoveByQueryOperationSupport.ReactiveRemoveByQuerySupport<T>(template.reactive(), domainType, query, scanConsistency, collection);
            this.scanConsistency = scanConsistency;
            this.collection = collection;
        }

        @Override
        public List<RemoveResult> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency, this.collection);
        }

        @Override
        @Deprecated
        public ExecutableRemoveByQueryOperation.RemoveByQueryInCollection<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.collection);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.collection);
        }

        @Override
        public ExecutableRemoveByQueryOperation.RemoveByQueryWithConsistency<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ExecutableRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, collection);
        }
    }
}

