/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.lang.Nullable;

public class QueryCriteria
implements QueryCriteriaDefinition {
    private final N1QLExpression key;
    private List<QueryCriteria> criteriaChain;
    private ChainOperator chainOperator;
    private String operator;
    private Object[] value;
    private String format;

    QueryCriteria(List<QueryCriteria> chain, N1QLExpression key, Object[] value, ChainOperator chainOperator) {
        this(chain, key, value, chainOperator, null, null);
    }

    QueryCriteria(List<QueryCriteria> chain, N1QLExpression key, Object value, ChainOperator chainOperator) {
        this(chain, key, new Object[]{value}, chainOperator, null, null);
    }

    QueryCriteria(List<QueryCriteria> chain, N1QLExpression key, Object[] value, ChainOperator chainOperator, String operator, String format) {
        this.criteriaChain = chain;
        this.criteriaChain.add(this);
        this.key = key;
        this.value = value;
        this.chainOperator = chainOperator;
        this.operator = operator;
        this.format = format;
    }

    Object[] getValue() {
        return this.value;
    }

    public static QueryCriteria where(String key) {
        return QueryCriteria.where(N1QLExpression.x(key));
    }

    public static QueryCriteria where(N1QLExpression key) {
        return new QueryCriteria(new ArrayList<QueryCriteria>(), key, null, null);
    }

    private static QueryCriteria wrap(QueryCriteria criteria) {
        QueryCriteria qc = new QueryCriteria(new LinkedList<QueryCriteria>(), criteria.key, criteria.value, null, criteria.operator, criteria.format);
        return qc;
    }

    public QueryCriteria and(String key) {
        return this.and(N1QLExpression.x(key));
    }

    public QueryCriteria and(N1QLExpression key) {
        return new QueryCriteria(this.criteriaChain, key, null, ChainOperator.AND);
    }

    public QueryCriteria and(QueryCriteria criteria) {
        return new QueryCriteria(this.criteriaChain, null, criteria, ChainOperator.AND);
    }

    public QueryCriteria or(String key) {
        return this.or(N1QLExpression.x(key));
    }

    public QueryCriteria or(N1QLExpression key) {
        return new QueryCriteria(this.criteriaChain, key, null, ChainOperator.OR);
    }

    public QueryCriteria or(QueryCriteria criteria) {
        return new QueryCriteria(this.criteriaChain, null, criteria, ChainOperator.OR);
    }

    public QueryCriteria eq(@Nullable Object o) {
        return this.is(o);
    }

    public QueryCriteria is(@Nullable Object o) {
        this.operator = "=";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria ne(@Nullable Object o) {
        this.operator = "!=";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria lt(@Nullable Object o) {
        this.operator = "<";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria lte(@Nullable Object o) {
        this.operator = "<=";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria gt(@Nullable Object o) {
        this.operator = ">";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria gte(@Nullable Object o) {
        this.operator = ">=";
        this.value = new Object[]{o};
        return this;
    }

    public QueryCriteria startingWith(@Nullable Object o) {
        this.operator = "STARTING_WITH";
        this.value = new Object[]{o};
        this.format = "%1$s like (%3$s||\"%%\")";
        return this;
    }

    public QueryCriteria plus(@Nullable Object o) {
        this.operator = "PLUS";
        this.value = new Object[]{o};
        this.format = "(%1$s || %3$s)";
        return this;
    }

    public QueryCriteria endingWith(@Nullable Object o) {
        this.operator = "ENDING_WITH";
        this.value = new Object[]{o};
        this.format = "%1$s like (\"%%\"||%3$s)";
        return this;
    }

    public QueryCriteria regex(@Nullable Object o) {
        this.operator = "REGEXP_LIKE";
        this.value = new Object[]{o};
        this.format = "regexp_like(%1$s, %3$s)";
        return this;
    }

    public QueryCriteria containing(@Nullable Object o) {
        this.operator = "CONTAINS";
        this.value = new Object[]{o};
        this.format = "contains(%1$s, %3$s)";
        return this;
    }

    public QueryCriteria notContaining(@Nullable Object o) {
        this.value = new QueryCriteria[]{QueryCriteria.wrap(this.containing(o))};
        this.operator = "NOT";
        this.format = "not( %3$s )";
        return this;
    }

    public QueryCriteria like(@Nullable Object o) {
        this.operator = "LIKE";
        this.value = new Object[]{o};
        this.format = "%1$s like %3$s";
        return this;
    }

    public QueryCriteria notLike(@Nullable Object o) {
        this.operator = "NOTLIKE";
        this.value = new Object[]{o};
        this.format = "not(%1$s like %3$s)";
        return this;
    }

    public QueryCriteria isNull() {
        this.operator = "IS_NULL";
        this.value = null;
        this.format = "%1$s is null";
        return this;
    }

    public QueryCriteria isNotNull() {
        this.operator = "IS_NOT_NULL";
        this.value = null;
        this.format = "%1$s is not null";
        return this;
    }

    public QueryCriteria isMissing() {
        this.operator = "IS_MISSING";
        this.value = null;
        this.format = "%1$s is missing";
        return this;
    }

    public QueryCriteria isNotMissing() {
        this.operator = "IS_NOT_MiSSING";
        this.value = null;
        this.format = "%1$s is not missing";
        return this;
    }

    public QueryCriteria isValued() {
        this.operator = "IS_VALUED";
        this.value = null;
        this.format = "%1$s is valued";
        return this;
    }

    public QueryCriteria isNotValued() {
        this.operator = "IS_NOT_VALUED";
        this.value = null;
        this.format = "%1$s is not valued";
        return this;
    }

    public QueryCriteria within(@Nullable Object o) {
        this.operator = "WITHIN";
        this.value = new Object[]{o};
        this.format = "%1$s within %3$s";
        return this;
    }

    public QueryCriteria between(@Nullable Object o1, @Nullable Object o2) {
        this.operator = "BETWEEN";
        this.value = new Object[]{o1, o2};
        this.format = "%1$s between %3$s and %4$s";
        return this;
    }

    public QueryCriteria in(Object ... o) {
        this.operator = "IN";
        this.format = "%1$s in ( %3$s )";
        if (o.length > 0) {
            if (o[0] instanceof JsonArray || o[0] instanceof List || o[0] instanceof Object[]) {
                if (o.length != 1) {
                    throw new RuntimeException("IN cannot take multiple lists");
                }
                this.value = o;
            } else {
                this.value = new Object[1];
                this.value[0] = o;
            }
        }
        return this;
    }

    public QueryCriteria notIn(Object ... o) {
        this.value = new QueryCriteria[]{QueryCriteria.wrap(this.in(o))};
        this.operator = "NOT";
        this.format = "not( %3$s )";
        return this;
    }

    public QueryCriteria TRUE() {
        this.value = null;
        this.operator = null;
        this.format = "%1$s";
        return this;
    }

    public QueryCriteria FALSE() {
        this.value = new QueryCriteria[]{QueryCriteria.wrap(this.TRUE())};
        this.operator = "not";
        this.format = "not( %3$s )";
        return this;
    }

    @Override
    public String export(int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        StringBuilder output = new StringBuilder();
        boolean first = true;
        for (QueryCriteria c : this.criteriaChain) {
            if (!first) {
                if (c.chainOperator == null) {
                    throw new IllegalStateException("A chain operator must be present when chaining!");
                }
                output.append(" ").append(c.chainOperator.representation).append(" ");
            } else {
                first = false;
            }
            c.exportSingle(output, paramIndexPtr, parameters, converter);
        }
        return output.toString();
    }

    @Override
    public String export() {
        return this.export(null, null, null);
    }

    private StringBuilder exportSingle(StringBuilder sb, int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        String fieldName = this.key == null ? null : this.key.toString();
        int valueLen = this.value == null ? 0 : this.value.length;
        Object[] v = new Object[valueLen + 2];
        v[0] = fieldName;
        v[1] = this.operator;
        for (int i = 0; i < valueLen; ++i) {
            v[i + 2] = this.value[i] instanceof QueryCriteria ? "(" + ((QueryCriteria)this.value[i]).export(paramIndexPtr, parameters, converter) + ")" : this.maybeWrapValue(this.key, this.value[i], paramIndexPtr, parameters, converter);
        }
        if (this.key == null) {
            sb.append(v[2]);
        } else if (this.format == null) {
            sb.append(fieldName).append(" ").append(this.operator).append(" ").append(v[2]);
        } else {
            sb.append(new Formatter().format(this.format, v));
        }
        return sb;
    }

    private String maybeWrapValue(N1QLExpression key, Object value, int[] paramIndexPtr, JsonValue parameters, CouchbaseConverter converter) {
        if (paramIndexPtr != null) {
            if (paramIndexPtr[0] >= 0) {
                JsonArray params = (JsonArray)parameters;
                try {
                    params.add(QueryCriteria.convert(converter, value));
                }
                catch (InvalidArgumentException iae) {
                    if (value instanceof Object[]) {
                        this.addAsArray(params, value, converter);
                    }
                    throw iae;
                }
                paramIndexPtr[0] = paramIndexPtr[0] + 1;
                return "$" + paramIndexPtr[0];
            }
            JsonObject params = (JsonObject)parameters;
            try {
                params.put(key.toString(), QueryCriteria.convert(converter, value));
            }
            catch (InvalidArgumentException iae) {
                if (value instanceof Object[]) {
                    params.put(key.toString(), JsonArray.from((Object[])((Object[])value)));
                }
                throw iae;
            }
            return "$" + key;
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            StringBuilder l = new StringBuilder();
            l.append("[");
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    l.append(",");
                }
                l.append(this.maybeWrapValue(null, array[i], null, null, converter));
            }
            l.append("]");
            return l.toString();
        }
        return value.toString();
    }

    private static Object convert(CouchbaseConverter converter, Object value) {
        return converter != null ? converter.convertForWriteIfNeeded(value) : value;
    }

    private void addAsArray(JsonArray posValues, Object o, CouchbaseConverter converter) {
        Object[] array = (Object[])o;
        JsonArray ja = JsonValue.ja();
        for (Object e : array) {
            ja.add(String.valueOf(QueryCriteria.convert(converter, e)));
        }
        posValues.add(ja);
    }

    private String maybeBackTic(String value) {
        if (value == null || value.startsWith("`") && value.endsWith("`")) {
            return value;
        }
        return "`" + value + "`";
    }

    static enum ChainOperator {
        AND("and"),
        OR("or");

        private final String representation;

        private ChainOperator(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

