/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.CouchbaseRepositoryQuery;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.SimpleCouchbaseRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactory
extends RepositoryFactorySupport {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private final RepositoryOperationsMapping couchbaseOperationsMapping;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;

    public CouchbaseRepositoryFactory(RepositoryOperationsMapping couchbaseOperationsMapping) {
        Assert.notNull((Object)couchbaseOperationsMapping, (String)"RepositoryOperationsMapping must not be null!");
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.mappingContext = this.couchbaseOperationsMapping.getMappingContext();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    public <T, ID> CouchbaseEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCouchbaseEntityInformation(entity);
    }

    protected final Object getTargetRepository(RepositoryInformation metadata) {
        CouchbaseOperations couchbaseOperations = this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleCouchbaseRepository repository = (SimpleCouchbaseRepository)this.getTargetRepositoryViaReflection(metadata, new Object[]{entityInformation, couchbaseOperations});
        repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        return repository;
    }

    protected final Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleCouchbaseRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider contextProvider) {
        return Optional.of(new CouchbaseQueryLookupStrategy(contextProvider));
    }

    private class CouchbaseQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public CouchbaseQueryLookupStrategy(QueryMethodEvaluationContextProvider evaluationContextProvider) {
            this.evaluationContextProvider = evaluationContextProvider;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CouchbaseOperations couchbaseOperations = CouchbaseRepositoryFactory.this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
            CouchbaseQueryMethod queryMethod = new CouchbaseQueryMethod(method, metadata, factory, CouchbaseRepositoryFactory.this.mappingContext);
            return new CouchbaseRepositoryQuery(couchbaseOperations, queryMethod, namedQueries);
        }
    }
}

