/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonValue;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.AbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlCountQueryCreator;
import org.springframework.data.couchbase.repository.query.N1qlMutateQueryCreator;
import org.springframework.data.couchbase.repository.query.OldN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeN1qlBasedQuery
extends AbstractN1qlBasedQuery {
    private final PartTree partTree;
    private JsonValue placeHolderValues;

    public PartTreeN1qlBasedQuery(CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations) {
        super(queryMethod, couchbaseOperations);
        this.partTree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.placeHolderValues;
    }

    @Override
    protected N1QLExpression getCount(ParameterAccessor accessor, Object[] runtimeParameters) {
        N1QLExpression bucket = N1QLExpression.i(this.getCouchbaseOperations().getBucketName());
        N1QLExpression countFrom = N1QLExpression.select(N1QLExpression.count(N1QLExpression.x("*")).as(N1QLExpression.x("count"))).from(bucket);
        N1qlCountQueryCreator queryCountCreator = new N1qlCountQueryCreator(this.partTree, accessor, countFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        N1QLExpression statement = (N1QLExpression)queryCountCreator.createQuery();
        this.placeHolderValues = queryCountCreator.getPlaceHolderValues();
        return statement;
    }

    @Override
    protected N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        String bucketName = this.getCouchbaseOperations().getBucketName();
        N1QLExpression bucket = N1qlUtils.escapedBucket(bucketName);
        if (this.partTree.isDelete()) {
            N1QLExpression deleteUsePath = N1QLExpression.delete().from(bucket);
            N1qlMutateQueryCreator mutateQueryCreator = new N1qlMutateQueryCreator(this.partTree, accessor, deleteUsePath, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
            N1QLExpression mutateFromWhereOrderBy = (N1QLExpression)mutateQueryCreator.createQuery();
            this.placeHolderValues = mutateQueryCreator.getPlaceHolderValues();
            if (this.partTree.isLimiting()) {
                return mutateFromWhereOrderBy.limit(this.partTree.getMaxResults());
            }
            return mutateFromWhereOrderBy.returning(N1qlUtils.createReturningExpressionForDelete(bucketName));
        }
        N1QLExpression select = this.partTree.isCountProjection() ? N1QLExpression.select(N1QLExpression.count(N1QLExpression.x("*"))) : N1qlUtils.createSelectClauseForEntity(bucketName, returnedType, this.getCouchbaseOperations().getConverter());
        N1QLExpression selectFrom = select.from(bucket);
        OldN1qlQueryCreator queryCreator = new OldN1qlQueryCreator(this.partTree, accessor, selectFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        N1QLExpression selectFromWhereOrderBy = (N1QLExpression)queryCreator.createQuery();
        this.placeHolderValues = queryCreator.getPlaceHolderValues();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            return selectFromWhereOrderBy.limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset()));
        }
        if (this.queryMethod.isSliceQuery() && accessor.getPageable().isPaged()) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            return selectFromWhereOrderBy.limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset()));
        }
        if (this.partTree.isLimiting()) {
            return selectFromWhereOrderBy.limit(this.partTree.getMaxResults());
        }
        return selectFromWhereOrderBy;
    }

    @Override
    protected boolean useGeneratedCountQuery() {
        return false;
    }
}

