/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.OldN1qlQueryCreator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlCountQueryCreator
extends OldN1qlQueryCreator {
    public N1qlCountQueryCreator(PartTree tree, ParameterAccessor parameters, N1QLExpression selectFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, new CountParameterAccessor(parameters), selectFrom, converter, queryMethod);
    }

    @Override
    protected N1QLExpression complete(N1QLExpression criteria, Sort sort) {
        return super.complete(criteria, Sort.unsorted());
    }

    private static class CountPageable
    implements Pageable {
        private Pageable delegate;

        public CountPageable(Pageable delegate) {
            this.delegate = delegate;
        }

        public int getPageNumber() {
            return this.delegate.getPageNumber();
        }

        public int getPageSize() {
            return this.delegate.getPageSize();
        }

        public long getOffset() {
            return this.delegate.getOffset();
        }

        public Sort getSort() {
            return Sort.unsorted();
        }

        public Pageable next() {
            return this.delegate.next();
        }

        public Pageable previousOrFirst() {
            return this.delegate.previousOrFirst();
        }

        public Pageable first() {
            return this.delegate.first();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }
    }

    private static class CountParameterAccessor
    implements ParameterAccessor {
        private ParameterAccessor delegate;

        public CountParameterAccessor(ParameterAccessor delegate) {
            this.delegate = delegate;
        }

        public Pageable getPageable() {
            return this.delegate.getPageable().isPaged() ? new CountPageable(this.delegate.getPageable()) : Pageable.unpaged();
        }

        public Sort getSort() {
            return Sort.unsorted();
        }

        public Optional<Class<?>> getDynamicProjection() {
            return this.delegate.getDynamicProjection();
        }

        public Class<?> findDynamicProjection() {
            return this.delegate.findDynamicProjection();
        }

        public Object getBindableValue(int index) {
            return this.delegate.getBindableValue(index);
        }

        public boolean hasBindableNullValue() {
            return this.delegate.hasBindableNullValue();
        }

        public Iterator<Object> iterator() {
            return this.delegate.iterator();
        }
    }
}

