/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.support;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;
import org.springframework.data.couchbase.core.OperationInterruptedException;

public class TemplateUtils {
    public static final String SELECT_ID = "__id";
    public static final String SELECT_CAS = "__cas";
    public static final String SELECT_COUNT = "__count";
    private static PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();

    public static Throwable translateError(Throwable e) {
        if (e instanceof RuntimeException) {
            return exceptionTranslator.translateExceptionIfPossible((RuntimeException)e);
        }
        if (e instanceof TimeoutException) {
            return new QueryTimeoutException(e.getMessage(), e);
        }
        if (e instanceof InterruptedException) {
            return new OperationInterruptedException(e.getMessage(), e);
        }
        if (e instanceof ExecutionException) {
            return new OperationInterruptedException(e.getMessage(), e);
        }
        return e;
    }
}

