/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Collection;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveRemoveByIdOperationSupport
implements ReactiveRemoveByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    public ReactiveRemoveByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ReactiveRemoveByIdOperation.ReactiveRemoveById removeById() {
        return new ReactiveRemoveByIdSupport(this.template, null, PersistTo.NONE, ReplicateTo.NONE, DurabilityLevel.NONE);
    }

    static class ReactiveRemoveByIdSupport
    implements ReactiveRemoveByIdOperation.ReactiveRemoveById {
        private final ReactiveCouchbaseTemplate template;
        private final String collection;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;

        ReactiveRemoveByIdSupport(ReactiveCouchbaseTemplate template, String collection, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel) {
            this.template = template;
            this.collection = collection;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
        }

        @Override
        public Mono<RemoveResult> one(String id) {
            return Mono.just((Object)id).flatMap(docId -> this.template.getCollection(this.collection).reactive().remove(id, this.buildRemoveOptions()).map(r -> RemoveResult.from(docId, r))).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<RemoveResult> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        private RemoveOptions buildRemoveOptions() {
            RemoveOptions options = RemoveOptions.removeOptions();
            if (this.persistTo != PersistTo.NONE || this.replicateTo != ReplicateTo.NONE) {
                options.durability(this.persistTo, this.replicateTo);
            } else if (this.durabilityLevel != DurabilityLevel.NONE) {
                options.durability(this.durabilityLevel);
            }
            return options;
        }

        @Override
        public ReactiveRemoveByIdOperation.TerminatingRemoveById inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveRemoveByIdSupport(this.template, collection, this.persistTo, this.replicateTo, this.durabilityLevel);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithCollection withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.collection, this.persistTo, this.replicateTo, durabilityLevel);
        }

        @Override
        public ReactiveRemoveByIdOperation.RemoveByIdWithCollection withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ReactiveRemoveByIdSupport(this.template, this.collection, persistTo, replicateTo, this.durabilityLevel);
        }
    }
}

