/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ReactiveExistsByIdOperationSupport
implements ReactiveExistsByIdOperation {
    private final ReactiveCouchbaseTemplate template;

    ReactiveExistsByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public ReactiveExistsByIdOperation.ReactiveExistsById existsById() {
        return new ReactiveExistsByIdSupport(this.template, null);
    }

    static class ReactiveExistsByIdSupport
    implements ReactiveExistsByIdOperation.ReactiveExistsById {
        private final ReactiveCouchbaseTemplate template;
        private final String collection;

        ReactiveExistsByIdSupport(ReactiveCouchbaseTemplate template, String collection) {
            this.template = template;
            this.collection = collection;
        }

        @Override
        public Mono<Boolean> one(String id) {
            return Mono.just((Object)id).flatMap(docId -> this.template.getCollection(this.collection).reactive().exists(id, ExistsOptions.existsOptions()).map(ExistsResult::exists)).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Mono<Map<String, Boolean>> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(id -> this.one((String)id).map(result -> Tuples.of((Object)id, (Object)result))).collectMap(Tuple2::getT1, Tuple2::getT2);
        }

        @Override
        public ReactiveExistsByIdOperation.TerminatingExistsById inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty.");
            return new ReactiveExistsByIdSupport(this.template, collection);
        }
    }
}

