/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.io.Serializable;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseSortingRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.couchbase.repository.support.SimpleReactiveCouchbaseRepository;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ReactiveN1qlCouchbaseRepository<T, ID extends Serializable>
extends SimpleReactiveCouchbaseRepository<T, ID>
implements ReactiveCouchbaseSortingRepository<T, ID> {
    public ReactiveN1qlCouchbaseRepository(CouchbaseEntityInformation<T, String> metadata, RxJavaCouchbaseOperations operations) {
        super(metadata, operations);
    }

    public Flux<T> findAll(Sort sort) {
        Assert.notNull((Object)sort);
        WherePath selectFrom = N1qlUtils.createSelectFromForEntity(this.getCouchbaseOperations().getCouchbaseBucket().name());
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(null, this.getCouchbaseOperations().getConverter(), this.getEntityInformation());
        com.couchbase.client.java.query.dsl.Sort[] orderings = N1qlUtils.createSort(sort, this.getCouchbaseOperations().getConverter());
        LimitPath st = selectFrom.where(whereCriteria).orderBy(orderings);
        ScanConsistency consistency = this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency();
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)st, (N1qlParams)N1qlParams.build().consistency(consistency));
        return this.mapFlux(this.getCouchbaseOperations().findByN1QL((N1qlQuery)query, this.getEntityInformation().getJavaType()));
    }
}

