/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.springframework.data.couchbase.repository.query.support.PointInShapeEvaluator;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;

public class AwtPointInShapeEvaluator
extends PointInShapeEvaluator {
    @Override
    public boolean pointInPolygon(Point p, Polygon polygon) {
        List points = polygon.getPoints();
        Path2D.Double awtPolygon = new Path2D.Double(0, points.size());
        boolean first = true;
        for (Point point : points) {
            if (first) {
                first = false;
                ((Path2D)awtPolygon).moveTo(point.getX(), point.getY());
                continue;
            }
            ((Path2D)awtPolygon).lineTo(point.getX(), point.getY());
        }
        awtPolygon.closePath();
        return this.pointInPolygon(p, awtPolygon);
    }

    @Override
    public boolean pointInPolygon(Point p, Point ... points) {
        if (points == null) {
            throw new NullPointerException("Polygon must at least contain 3 points");
        }
        if (points.length < 3) {
            throw new IllegalArgumentException("Polygon must at least contain 3 points");
        }
        Path2D.Double awtPolygon = new Path2D.Double(0, points.length);
        boolean first = true;
        for (Point point : points) {
            if (first) {
                first = false;
                ((Path2D)awtPolygon).moveTo(point.getX(), point.getY());
                continue;
            }
            ((Path2D)awtPolygon).lineTo(point.getX(), point.getY());
        }
        awtPolygon.closePath();
        return this.pointInPolygon(p, awtPolygon);
    }

    @Override
    public boolean pointInCircle(Point p, Circle c) {
        Point2D.Double center = new Point2D.Double(c.getCenter().getX(), c.getCenter().getY());
        return this.pointNear(p, center, c.getRadius().getNormalizedValue());
    }

    @Override
    public boolean pointInCircle(Point p, Point center, Distance radiusDistance) {
        double radius = radiusDistance.getNormalizedValue();
        return this.pointNear(p, new Point2D.Double(center.getX(), center.getY()), radius);
    }

    private boolean pointInPolygon(Point p, Path2D awtPolygon) {
        return awtPolygon.contains(p.getX(), p.getY());
    }

    private boolean pointNear(Point p, Point2D center, double distance) {
        return center.distance(p.getX(), p.getY()) <= distance;
    }
}

