/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ViewQueryCreator;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

public class ViewBasedCouchbaseQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(ViewBasedCouchbaseQuery.class);
    private final CouchbaseQueryMethod method;
    private final CouchbaseOperations operations;

    public ViewBasedCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] runtimeParams) {
        if (this.method.hasViewName()) {
            return this.deriveAndExecute(runtimeParams);
        }
        return this.guessViewAndExecute();
    }

    protected Object guessViewAndExecute() {
        String designDoc = ViewBasedCouchbaseQuery.designDocName(this.method);
        String methodName = this.method.getName();
        boolean isExplicitReduce = this.method.hasViewAnnotation() && this.method.getViewAnnotation().reduce();
        boolean isReduce = methodName.startsWith("count") || isExplicitReduce;
        String viewName = StringUtils.uncapitalize((String)methodName.replaceFirst("find|count", ""));
        ViewQuery simpleQuery = ViewQuery.from((String)designDoc, (String)viewName).stale(this.operations.getDefaultConsistency().viewConsistency());
        if (isReduce) {
            simpleQuery.reduce();
            return this.executeReduce(simpleQuery, designDoc, viewName);
        }
        return this.execute(simpleQuery);
    }

    protected Object deriveAndExecute(Object[] runtimeParams) {
        String designDoc = ViewBasedCouchbaseQuery.designDocName(this.method);
        String viewName = this.method.getViewAnnotation().viewName();
        ViewQuery baseQuery = ViewQuery.from((String)designDoc, (String)viewName).stale(this.operations.getDefaultConsistency().viewConsistency());
        try {
            PartTree tree = new PartTree(this.method.getName(), this.method.getEntityInformation().getJavaType());
            ViewQueryCreator creator = new ViewQueryCreator(tree, (ParameterAccessor)new ParametersParameterAccessor(this.method.getParameters(), runtimeParams), this.method.getViewAnnotation(), baseQuery, this.operations.getConverter());
            ViewQueryCreator.DerivedViewQuery result = (ViewQueryCreator.DerivedViewQuery)creator.createQuery();
            if (result.isReduce) {
                return this.executeReduce(result.builtQuery, designDoc, viewName);
            }
            return this.execute(result.builtQuery);
        }
        catch (PropertyReferenceException e) {
            if (e.getPropertyName().equals(this.method.getName())) {
                return this.execute(baseQuery);
            }
            throw e;
        }
    }

    protected Object execute(ViewQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing view query: " + query.toString());
        }
        return this.operations.findByView(query, this.method.getEntityInformation().getJavaType());
    }

    protected Object executeReduce(ViewQuery query, String designDoc, String viewName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing view reduced query: " + query.toString());
        }
        ViewResult viewResult = this.operations.queryView(query);
        List allRows = viewResult.allRows();
        JsonObject error = viewResult.error();
        if (error != null) {
            throw new CouchbaseQueryExecutionException("Error while reducing on view " + designDoc + "/" + viewName + ": " + error);
        }
        if (allRows == null || allRows.isEmpty()) {
            return null;
        }
        return ((ViewRow)allRows.get(0)).value();
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    private static String designDocName(CouchbaseQueryMethod method) {
        if (method.hasViewSpecification()) {
            return method.getViewAnnotation().designDocument();
        }
        if (method.hasViewAnnotation()) {
            return StringUtils.uncapitalize((String)method.getEntityInformation().getJavaType().getSimpleName());
        }
        throw new IllegalStateException("View-based query should only happen on a method with @View annotation");
    }
}

