/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.Delete;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.AggregateFunctions;
import com.couchbase.client.java.query.dsl.path.AsPath;
import com.couchbase.client.java.query.dsl.path.DeleteUsePath;
import com.couchbase.client.java.query.dsl.path.FromPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.MutateLimitPath;
import com.couchbase.client.java.query.dsl.path.MutateWherePath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.query.AbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlCountQueryCreator;
import org.springframework.data.couchbase.repository.query.N1qlMutateQueryCreator;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeN1qlBasedQuery
extends AbstractN1qlBasedQuery {
    private final PartTree partTree;
    private JsonValue placeHolderValues;

    public PartTreeN1qlBasedQuery(CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations) {
        super(queryMethod, couchbaseOperations);
        this.partTree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.placeHolderValues;
    }

    @Override
    protected Statement getCount(ParameterAccessor accessor, Object[] runtimeParameters) {
        Expression bucket = Expression.i((String[])new String[]{this.getCouchbaseOperations().getCouchbaseBucket().name()});
        AsPath countFrom = Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*").as("count")}).from(bucket);
        N1qlCountQueryCreator queryCountCreator = new N1qlCountQueryCreator(this.partTree, accessor, (WherePath)countFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        Statement statement = (Statement)queryCountCreator.createQuery();
        this.placeHolderValues = queryCountCreator.getPlaceHolderValues();
        return statement;
    }

    @Override
    protected Statement getStatement(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        String bucketName = this.getCouchbaseOperations().getCouchbaseBucket().name();
        Expression bucket = N1qlUtils.escapedBucket(bucketName);
        if (this.partTree.isDelete()) {
            DeleteUsePath deleteUsePath = Delete.deleteFrom((Expression)bucket);
            N1qlMutateQueryCreator mutateQueryCreator = new N1qlMutateQueryCreator(this.partTree, accessor, (MutateWherePath)deleteUsePath, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
            MutateLimitPath mutateFromWhereOrderBy = (MutateLimitPath)mutateQueryCreator.createQuery();
            this.placeHolderValues = mutateQueryCreator.getPlaceHolderValues();
            if (this.partTree.isLimiting()) {
                return mutateFromWhereOrderBy.limit(this.partTree.getMaxResults().intValue());
            }
            return mutateFromWhereOrderBy.returning(N1qlUtils.createReturningExpressionForDelete(bucketName));
        }
        FromPath select = this.partTree.isCountProjection() ? Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*")}) : N1qlUtils.createSelectClauseForEntity(bucketName, returnedType, this.getCouchbaseOperations().getConverter());
        AsPath selectFrom = select.from(bucket);
        N1qlQueryCreator queryCreator = new N1qlQueryCreator(this.partTree, accessor, (WherePath)selectFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        LimitPath selectFromWhereOrderBy = (LimitPath)queryCreator.createQuery();
        this.placeHolderValues = queryCreator.getPlaceHolderValues();
        if (this.queryMethod.isPageQuery()) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            return selectFromWhereOrderBy.limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset()));
        }
        if (this.queryMethod.isSliceQuery() && accessor.getPageable().isPaged()) {
            Pageable pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            return selectFromWhereOrderBy.limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset()));
        }
        if (this.partTree.isLimiting()) {
            return selectFromWhereOrderBy.limit(this.partTree.getMaxResults().intValue());
        }
        return selectFromWhereOrderBy;
    }

    @Override
    protected boolean useGeneratedCountQuery() {
        return false;
    }
}

