/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryFactory;
import org.springframework.data.couchbase.repository.support.IndexManager;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private RepositoryOperationsMapping operationsMapping;
    private IndexManager indexManager;

    public CouchbaseRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setCouchbaseOperations(CouchbaseOperations operations) {
        this.setCouchbaseOperationsMapping(new RepositoryOperationsMapping(operations));
    }

    public void setCouchbaseOperationsMapping(RepositoryOperationsMapping mapping) {
        this.operationsMapping = mapping;
        this.setMappingContext(this.operationsMapping.getMappingContext());
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.operationsMapping, this.indexManager);
    }

    protected CouchbaseRepositoryFactory getFactoryInstance(RepositoryOperationsMapping operationsMapping, IndexManager indexManager) {
        return new CouchbaseRepositoryFactory(operationsMapping, indexManager);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operationsMapping, (String)"operationsMapping must not be null!");
        Assert.notNull((Object)this.indexManager, (String)"indexManager must not be null!");
    }
}

