/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.util.features.CouchbaseFeature;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.core.UnsupportedCouchbaseFeatureException;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1qlPrimaryIndexed;
import org.springframework.data.couchbase.core.query.N1qlSecondaryIndexed;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.core.query.ViewIndexed;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactivePartTreeN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.ReactiveSpatialViewBasedQuery;
import org.springframework.data.couchbase.repository.query.ReactiveStringN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.ReactiveViewBasedCouchbaseQuery;
import org.springframework.data.couchbase.repository.support.IndexManager;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.ReactiveN1qlCouchbaseRepository;
import org.springframework.data.couchbase.repository.support.SimpleReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.support.ViewPostProcessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveCouchbaseRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private final ReactiveRepositoryOperationsMapping couchbaseOperationsMapping;
    private final IndexManager indexManager;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final ViewPostProcessor viewPostProcessor;

    public ReactiveCouchbaseRepositoryFactory(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping, IndexManager indexManager) {
        Assert.notNull((Object)couchbaseOperationsMapping);
        Assert.notNull((Object)indexManager);
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.indexManager = indexManager;
        this.mappingContext = this.couchbaseOperationsMapping.getMappingContext();
        this.viewPostProcessor = ViewPostProcessor.INSTANCE;
        this.addRepositoryProxyPostProcessor(this.viewPostProcessor);
    }

    public <T, ID> CouchbaseEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCouchbaseEntityInformation(entity);
    }

    protected final Object getTargetRepository(RepositoryInformation metadata) {
        RxJavaCouchbaseOperations couchbaseOperations = this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
        boolean isN1qlAvailable = couchbaseOperations.getCouchbaseClusterInfo().checkAvailable(CouchbaseFeature.N1QL);
        ViewIndexed viewIndexed = (ViewIndexed)AnnotationUtils.findAnnotation((Class)metadata.getRepositoryInterface(), ViewIndexed.class);
        N1qlPrimaryIndexed n1qlPrimaryIndexed = (N1qlPrimaryIndexed)AnnotationUtils.findAnnotation((Class)metadata.getRepositoryInterface(), N1qlPrimaryIndexed.class);
        N1qlSecondaryIndexed n1qlSecondaryIndexed = (N1qlSecondaryIndexed)AnnotationUtils.findAnnotation((Class)metadata.getRepositoryInterface(), N1qlSecondaryIndexed.class);
        this.checkFeatures(metadata, isN1qlAvailable, n1qlPrimaryIndexed, n1qlSecondaryIndexed);
        this.indexManager.buildIndexes(metadata, viewIndexed, n1qlPrimaryIndexed, n1qlSecondaryIndexed, couchbaseOperations);
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleReactiveCouchbaseRepository repo = (SimpleReactiveCouchbaseRepository)this.getTargetRepositoryViaReflection(metadata, new Object[]{entityInformation, couchbaseOperations});
        repo.setViewMetadataProvider(this.viewPostProcessor.getViewMetadataProvider());
        return repo;
    }

    private void checkFeatures(RepositoryInformation metadata, boolean isN1qlAvailable, N1qlPrimaryIndexed n1qlPrimaryIndexed, N1qlSecondaryIndexed n1qlSecondaryIndexed) {
        boolean needsN1ql;
        boolean bl = needsN1ql = metadata.isPagingRepository() || n1qlPrimaryIndexed != null || n1qlSecondaryIndexed != null;
        if (!needsN1ql) {
            for (Method method : metadata.getQueryMethods()) {
                boolean hasView;
                boolean hasN1ql = AnnotationUtils.findAnnotation((Method)method, Query.class) != null;
                boolean bl2 = hasView = AnnotationUtils.findAnnotation((Method)method, View.class) != null;
                if (!hasN1ql && hasView) continue;
                needsN1ql = true;
                break;
            }
        }
        if (needsN1ql && !isN1qlAvailable) {
            throw new UnsupportedCouchbaseFeatureException("Repository uses N1QL", CouchbaseFeature.N1QL);
        }
    }

    protected final Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        RxJavaCouchbaseOperations couchbaseOperations = this.couchbaseOperationsMapping.resolve(repositoryMetadata.getRepositoryInterface(), repositoryMetadata.getDomainType());
        boolean isN1qlAvailable = couchbaseOperations.getCouchbaseClusterInfo().checkAvailable(CouchbaseFeature.N1QL);
        if (isN1qlAvailable) {
            return this.getN1qlBaseClass(repositoryMetadata);
        }
        return this.getSimpleBaseClass(repositoryMetadata);
    }

    protected Class<? extends ReactiveN1qlCouchbaseRepository> getN1qlBaseClass(RepositoryMetadata repositoryMetadata) {
        return ReactiveN1qlCouchbaseRepository.class;
    }

    protected Class<? extends SimpleReactiveCouchbaseRepository> getSimpleBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleReactiveCouchbaseRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider contextProvider) {
        return Optional.of(new CouchbaseQueryLookupStrategy(contextProvider));
    }

    private class CouchbaseQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EvaluationContextProvider evaluationContextProvider;

        public CouchbaseQueryLookupStrategy(EvaluationContextProvider evaluationContextProvider) {
            this.evaluationContextProvider = evaluationContextProvider;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            RxJavaCouchbaseOperations couchbaseOperations = ReactiveCouchbaseRepositoryFactory.this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
            CouchbaseQueryMethod queryMethod = new CouchbaseQueryMethod(method, metadata, factory, ReactiveCouchbaseRepositoryFactory.this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (queryMethod.hasDimensionalAnnotation()) {
                return new ReactiveSpatialViewBasedQuery(queryMethod, couchbaseOperations);
            }
            if (queryMethod.hasViewAnnotation()) {
                return new ReactiveViewBasedCouchbaseQuery(queryMethod, couchbaseOperations);
            }
            if (queryMethod.hasN1qlAnnotation()) {
                if (queryMethod.hasInlineN1qlQuery()) {
                    return new ReactiveStringN1qlBasedQuery(queryMethod.getInlineN1qlQuery(), queryMethod, couchbaseOperations, SPEL_PARSER, this.evaluationContextProvider);
                }
                if (namedQueries.hasQuery(namedQueryName)) {
                    String namedQuery = namedQueries.getQuery(namedQueryName);
                    return new ReactiveStringN1qlBasedQuery(namedQuery, queryMethod, couchbaseOperations, SPEL_PARSER, this.evaluationContextProvider);
                }
            }
            return new ReactivePartTreeN1qlBasedQuery(queryMethod, couchbaseOperations);
        }
    }
}

