/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.protocol.views.ComplexKey;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewRow;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.view.View;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.ViewMetadataProvider;
import org.springframework.util.Assert;

public class SimpleCouchbaseRepository<T, ID extends Serializable>
implements CouchbaseRepository<T, ID> {
    private final CouchbaseOperations couchbaseOperations;
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private ViewMetadataProvider viewMetadataProvider;

    public SimpleCouchbaseRepository(CouchbaseEntityInformation<T, String> metadata, CouchbaseOperations couchbaseOperations) {
        Assert.notNull((Object)couchbaseOperations);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.couchbaseOperations = couchbaseOperations;
    }

    public void setViewMetadataProvider(ViewMetadataProvider viewMetadataProvider) {
        this.viewMetadataProvider = viewMetadataProvider;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.couchbaseOperations.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            this.save(entity);
            result.add(entity);
        }
        return result;
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.couchbaseOperations.findById(id.toString(), this.entityInformation.getJavaType());
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.couchbaseOperations.exists(id.toString());
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.couchbaseOperations.remove(id.toString());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given id must not be null!");
        this.couchbaseOperations.remove(entity);
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        for (T entity : entities) {
            this.couchbaseOperations.remove(entity);
        }
    }

    public Iterable<T> findAll() {
        ResolvedView resolvedView = this.determineView();
        return this.couchbaseOperations.findByView(resolvedView.getDesignDocument(), resolvedView.getViewName(), new Query().setReduce(false), this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        Query query = new Query();
        query.setReduce(false);
        query.setKeys(ComplexKey.of((Object[])new Object[]{ids}));
        ResolvedView resolvedView = this.determineView();
        return this.couchbaseOperations.findByView(resolvedView.getDesignDocument(), resolvedView.getViewName(), query, this.entityInformation.getJavaType());
    }

    public long count() {
        Query query = new Query();
        query.setReduce(true);
        ResolvedView resolvedView = this.determineView();
        ViewResponse response = this.couchbaseOperations.queryView(resolvedView.getDesignDocument(), resolvedView.getViewName(), query);
        long count = 0L;
        for (ViewRow row : response) {
            count += Long.parseLong(row.getValue());
        }
        return count;
    }

    public void deleteAll() {
        Query query = new Query();
        query.setReduce(false);
        ResolvedView resolvedView = this.determineView();
        ViewResponse response = this.couchbaseOperations.queryView(resolvedView.getDesignDocument(), resolvedView.getViewName(), query);
        for (ViewRow row : response) {
            this.couchbaseOperations.remove(row.getId());
        }
    }

    protected CouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }

    protected CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    private ResolvedView determineView() {
        String designDocument = this.entityInformation.getJavaType().getSimpleName().toLowerCase();
        String viewName = "all";
        View view = this.viewMetadataProvider.getView();
        if (view != null) {
            designDocument = view.designDocument();
            viewName = view.viewName();
        }
        return new ResolvedView(designDocument, viewName);
    }

    private final class ResolvedView {
        private final String designDocument;
        private final String viewName;

        public ResolvedView(String designDocument, String viewName) {
            this.designDocument = designDocument;
            this.viewName = viewName;
        }

        private String getDesignDocument() {
            return this.designDocument;
        }

        private String getViewName() {
            return this.viewName;
        }
    }
}

